/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRTermUebList;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVTermUebSEPAList
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVTermUebSEPAList(HBCIPassportInternal passport) {
        super(passport, GVTermUebSEPAList.getLowlevelName(), new GVRTermUebList(passport));
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN());
        this.addConstraint("startdate", "startdate", "");
        this.addConstraint("enddate", "enddate", "");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "TermUebSEPAList";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRTermUebList.Entry entry = new GVRTermUebList.Entry();
        entry.my = new Konto();
        entry.my.country = result.get(header + ".My.KIK.country");
        entry.my.blz = result.get(header + ".My.KIK.blz");
        entry.my.number = result.get(header + ".My.number");
        entry.my.subnumber = result.get(header + ".My.subnumber");
        entry.my.iban = result.get(header + ".My.iban");
        entry.my.bic = result.get(header + ".My.bic");
        this.passport.fillAccountInfo(entry.my);
        entry.other = new Konto();
        String sepadescr = result.get(header + ".sepadescr");
        String pain = result.get(header + ".sepapain");
        SepaVersion version = SepaVersion.choose(sepadescr, pain);
        ISEPAParser parser = SEPAParserFactory.get(version);
        ArrayList sepaResults = new ArrayList();
        try {
            parser.parse(new ByteArrayInputStream(pain.getBytes(CommPinTan.ENCODING)), sepaResults);
        }
        catch (Exception e) {
            throw new HBCI_Exception("Error parsing SEPA pain document", e);
        }
        if (sepaResults.isEmpty()) {
            return;
        }
        HashMap separesult = (HashMap)sepaResults.get(0);
        entry.other.iban = (String)separesult.get("dst.iban");
        entry.other.bic = (String)separesult.get("dst.bic");
        entry.other.name = (String)separesult.get("dst.name");
        entry.value = new Value((String)separesult.get("value"), (String)separesult.get("curr"));
        entry.addUsage((String)separesult.get("usage"));
        entry.orderid = result.get(header + ".orderid");
        entry.date = HBCIUtils.string2DateISO((String)separesult.get("date"));
        entry.can_change = result.get(header + ".canchange") == null || result.get(header + ".canchange").equals("J");
        entry.can_delete = result.get(header + ".candel") == null || result.get(header + ".candel").equals("J");
        ((GVRTermUebList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            HashMap p2 = new HashMap();
            result.keySet().forEach(key -> {
                if (key.startsWith(header + ".") && !key.startsWith(header + ".SegHead.") && !key.endsWith(".orderid")) {
                    p2.put(key.substring(header.length() + 1), (String)result.get(key));
                }
            });
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

