/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Base64;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKontoauszugPdf
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVKontoauszugPdf.class);

    public GVKontoauszugPdf(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRKontoauszug(passport));
    }

    public GVKontoauszugPdf(HBCIPassportInternal passport) {
        this(passport, GVKontoauszugPdf.getLowlevelName());
        this.addConstraint("my.bic", "My.bic", null);
        this.addConstraint("my.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("my.country", "My.KIK.country", "DE");
            this.addConstraint("my.blz", "My.KIK.blz", "");
            this.addConstraint("my.number", "My.number", "");
            this.addConstraint("my.subnumber", "My.subnumber", "");
        }
        this.addConstraint("idx", "idx", "");
        this.addConstraint("year", "year", "");
        this.addConstraint("maxentries", "maxentries", "");
        this.addConstraint("offset", "offset", "");
    }

    public static String getLowlevelName() {
        return "KontoauszugPdf";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String receipt;
        HashMap<String, String> result = msgstatus.getData();
        GVRKontoauszug list = (GVRKontoauszug)this.jobResult;
        GVRKontoauszug.GVRKontoauszugEntry auszug = new GVRKontoauszug.GVRKontoauszugEntry();
        list.getEntries().add(auszug);
        auszug.setFormat(GVRKontoauszug.Format.PDF);
        String start = result.get(header + ".TimeRange.startdate");
        String end = result.get(header + ".TimeRange.enddate");
        String date = result.get(header + ".date");
        String year = result.get(header + ".year");
        String number = result.get(header + ".number");
        if (start != null && start.length() > 0) {
            auszug.setStartDate(HBCIUtils.string2DateISO(start));
        }
        if (end != null && end.length() > 0) {
            auszug.setEndDate(HBCIUtils.string2DateISO(end));
        }
        if (date != null && date.length() > 0) {
            auszug.setDate(HBCIUtils.string2DateISO(date));
        }
        if (year != null && year.length() > 0) {
            auszug.setYear(Integer.parseInt(year));
        }
        if (number != null && number.length() > 0) {
            auszug.setNumber(Integer.parseInt(number));
        }
        auszug.setIBAN(result.get(header + ".iban"));
        auszug.setBIC(result.get(header + ".bic"));
        auszug.setName(result.get(header + ".name"));
        auszug.setName2(result.get(header + ".name2"));
        auszug.setName3(result.get(header + ".name3"));
        auszug.setFilename(result.get(header + ".filename"));
        String data = result.get(header + ".booked");
        if (data != null && data.length() > 0) {
            if (data.startsWith("%PDF-")) {
                auszug.setData(data.getBytes(CommPinTan.ENCODING));
            } else {
                auszug.setData(Base64.getDecoder().decode(data.getBytes(CommPinTan.ENCODING)));
            }
        }
        if ((receipt = result.get(header + ".receipt")) != null) {
            auszug.setReceipt(receipt.getBytes(CommPinTan.ENCODING));
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

