/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.swift.Swift;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKontoauszug
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVKontoauszug.class);

    public GVKontoauszug(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRKontoauszug(passport));
    }

    public GVKontoauszug(HBCIPassportInternal passport) {
        this(passport, GVKontoauszug.getLowlevelName());
        boolean sepa = false;
        try {
            sepa = this.getSegVersion() >= 4;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        boolean nat = this.canNationalAcc(passport);
        if (sepa) {
            this.addConstraint("my.bic", "My.bic", null);
            this.addConstraint("my.iban", "My.iban", null);
        }
        if (nat || !sepa) {
            this.addConstraint("my.country", "My.KIK.country", "DE");
            this.addConstraint("my.blz", "My.KIK.blz", "");
            this.addConstraint("my.number", "My.number", "");
            this.addConstraint("my.subnumber", "My.subnumber", "");
        }
        this.addConstraint("format", "format", "");
        this.addConstraint("idx", "idx", "");
        this.addConstraint("year", "year", "");
        this.addConstraint("maxentries", "maxentries", "");
        this.addConstraint("offset", "offset", "");
    }

    public static String getLowlevelName() {
        return "Kontoauszug";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String date;
        HashMap<String, String> result = msgstatus.getData();
        GVRKontoauszug list = (GVRKontoauszug)this.jobResult;
        GVRKontoauszug.GVRKontoauszugEntry auszug = new GVRKontoauszug.GVRKontoauszugEntry();
        list.getEntries().add(auszug);
        GVRKontoauszug.Format format = GVRKontoauszug.Format.find(result.get(header + ".format"));
        auszug.setFormat(format);
        String data = result.get(header + ".booked");
        if (data != null && data.length() > 0) {
            if (format == GVRKontoauszug.Format.MT940) {
                data = Swift.decodeUmlauts(data);
            }
            auszug.setData(data.getBytes(CommPinTan.ENCODING));
        }
        if ((date = result.get(header + ".date")) != null && date.length() > 0) {
            auszug.setDate(HBCIUtils.string2DateISO(date));
        }
        String year = result.get(header + ".year");
        String number = result.get(header + ".number");
        if (year != null && year.length() > 0) {
            auszug.setYear(Integer.parseInt(year));
        }
        if (number != null && number.length() > 0) {
            auszug.setNumber(Integer.parseInt(number));
        }
        auszug.setStartDate(HBCIUtils.string2DateISO(result.get(header + ".TimeRange.startdate")));
        auszug.setEndDate(HBCIUtils.string2DateISO(result.get(header + ".TimeRange.enddate")));
        auszug.setAbschlussInfo(result.get(header + ".abschlussinfo"));
        auszug.setKundenInfo(result.get(header + ".kondinfo"));
        auszug.setWerbetext(result.get(header + ".ads"));
        auszug.setIBAN(result.get(header + ".iban"));
        auszug.setBIC(result.get(header + ".bic"));
        auszug.setName(result.get(header + ".name"));
        auszug.setName2(result.get(header + ".name2"));
        auszug.setName3(result.get(header + ".name3"));
        String receipt = result.get(header + ".receipt");
        if (receipt != null) {
            auszug.setReceipt(receipt.getBytes(CommPinTan.ENCODING));
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

