/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.DE;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MultipleDEs
extends MultipleSyntaxElements {
    private static final Logger log = LoggerFactory.getLogger(MultipleDEs.class);
    private char delimiter;
    private List<String> valids;

    public MultipleDEs(Node dedef, char delimiter, String path, Document document) {
        super(dedef, path, document);
        this.initData(delimiter);
    }

    public MultipleDEs(Node deref, char delimiter, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        super(deref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
        this.initData(delimiter);
    }

    @Override
    protected SyntaxElement createAndAppendNewElement(Node deref, String path, int idx, Document document) {
        DE ret = new DE(deref, this.getName(), path, idx, document);
        this.addElement(ret);
        return ret;
    }

    public void init(Node dedef, char delimiter, String path, Document document) {
        super.init(dedef, path, document);
        this.initData(delimiter);
    }

    @Override
    protected boolean storeValidValueInDE(String destPath, String value) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            this.valids.add(value);
            ret = true;
        }
        return ret;
    }

    @Override
    protected void validateOneElement(SyntaxElement elem, int idx) {
        ((DE)elem).setValids(this.valids);
        super.validateOneElement(elem, idx);
    }

    @Override
    public String toString(int dummy) {
        StringBuilder ret = new StringBuilder(128);
        boolean first = true;
        ListIterator<SyntaxElement> i = this.getElements().listIterator();
        while (i.hasNext()) {
            if (!first) {
                ret.append(this.delimiter);
            }
            first = false;
            DE de = (DE)i.next();
            if (de == null) continue;
            ret.append(de.toString(0));
        }
        return ret.toString();
    }

    @Override
    protected SyntaxElement parseAndAppendNewElement(Node ref, String path, char predelim, int idx, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        HashMap newValids = new HashMap();
        if (idx != 0 && valids != null) {
            String header = this.getPath() + ".value";
            valids.forEach((key, value) -> {
                if (key.startsWith(header) && key.indexOf(".", header.length()) == -1) {
                    int dotPos = key.lastIndexOf(46);
                    String newKey = key.substring(0, dotPos) + HBCIUtils.withCounter("", idx) + key.substring(dotPos);
                    newValids.put(newKey, value);
                }
            });
        }
        valids.putAll(newValids);
        DE ret = new DE(ref, this.getName(), path, predelim, idx, res, fullResLen, predefs, valids);
        this.addElement(ret);
        return ret;
    }

    private void initData(char delimiter) {
        this.delimiter = delimiter;
        this.valids = new ArrayList<String>();
    }

    public void init(Node deref, char delimiter, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        super.init(deref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
        this.initData(delimiter);
    }

    @Override
    public void getElementPaths(Map<String, String> p, int[] segref, int[] degref, int[] deref) {
        if (this.getElements().size() != 0) {
            for (SyntaxElement e : this.getElements()) {
                if (e == null) continue;
                e.getElementPaths(p, segref, degref, deref);
            }
        } else if (deref == null) {
            p.put(segref[0] + ":" + degref[0], this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.put(segref[0] + ":" + degref[0] + "," + deref[0], this.getPath());
            deref[0] = deref[0] + 1;
        }
    }

    @Override
    public void destroy() {
        this.valids.clear();
        this.valids = null;
        super.destroy();
    }
}

