/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kapott.hbci.GV.GVRawSEPA;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.JobNotSupportedException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.KnownReturncode;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractHBCIJob.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile("(\\w+\\.\\w+\\.\\w+)(\\.\\w+)?");
    protected HBCIJobResultImpl jobResult;
    protected HBCIPassportInternal passport;
    private String name;
    private String jobName;
    private int segVersion;
    private Map<String, String> llParams;
    private int idx;
    private int contentCounter;
    private HashMap<String, String[][]> constraints;
    private HashSet<String> indexedConstraints;
    private int loopCount = 0;
    private boolean skip = false;
    private boolean veu = false;

    public AbstractHBCIJob(HBCIPassportInternal passport, String jobnameLL, HBCIJobResultImpl jobResult) {
        this.passport = passport;
        this.findSpecNameForGV(jobnameLL);
        this.llParams = new HashMap<String, String>();
        this.jobResult = Optional.ofNullable(jobResult).orElseGet(() -> new HBCIJobResultImpl(passport));
        this.contentCounter = 0;
        this.constraints = new HashMap();
        this.indexedConstraints = new HashSet();
        this.llParams.put(this.name, "requested");
    }

    public void setLlParams(Map<String, String> llParams) {
        this.llParams = llParams;
    }

    public String getHBCICode() {
        return this.getHBCICode(true);
    }

    public String getHBCICode(boolean reduce) {
        StringBuilder ret = null;
        StringBuilder searchString = new StringBuilder(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".SegHead.code");
            break;
        }
        StringBuilder tempkey = new StringBuilder();
        for (String key : this.passport.getBPD().keySet()) {
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = new StringBuilder(this.passport.getBPD().get(key));
            ret.replace(1, 2, "K");
            if (!reduce) break;
            ret.deleteCharAt(ret.length() - 1);
            break;
        }
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }

    public String getJobName() {
        return this.jobName;
    }

    protected boolean canNationalAcc(HBCIPassportInternal passport) {
        log.debug("searching for value of \"cannationalacc\" in HISPAS");
        if (!passport.jobSupported("SEPAInfo")) {
            log.info("no HISPAS data found");
            return false;
        }
        Map<String, String> props = passport.getLowlevelJobRestrictions("SEPAInfo");
        String value = props.get("cannationalacc");
        log.debug("cannationalacc=" + value);
        return value != null && value.equalsIgnoreCase("J");
    }

    private void findSpecNameForGV(String jobnameLL) {
        int maxVersion = 0;
        StringBuilder key = new StringBuilder();
        Map<String, String> bpd = this.passport.getBPD();
        for (String path : bpd.keySet()) {
            key.setLength(0);
            key.append(path);
            if (key.indexOf("Params") != 0) continue;
            key.delete(0, key.indexOf(".") + 1);
            if (key.indexOf(jobnameLL + "Par") != 0 || !key.toString().endsWith(".SegHead.code")) continue;
            key.delete(0, jobnameLL.length() + "Par".length());
            String st = key.substring(0, key.indexOf("."));
            int version = 0;
            try {
                version = Integer.parseInt(st);
            }
            catch (Exception e) {
                log.warn("found invalid job version: key=" + key + ", jobnameLL=" + jobnameLL + " (this is a known, but harmless bug)");
            }
            if (version == 0) continue;
            log.debug("task " + jobnameLL + " is supported with segment version " + st);
            if (version <= maxVersion) continue;
            maxVersion = version;
        }
        if (maxVersion == 0 && !jobnameLL.equals(GVRawSEPA.getLowlevelName())) {
            maxVersion = 1;
            log.warn("Using segment version " + maxVersion + " for job " + jobnameLL + ", although not found in BPD. This may fail");
            throw new JobNotSupportedException(jobnameLL);
        }
        this.jobName = jobnameLL;
        this.segVersion = maxVersion;
        this.name = jobnameLL + this.segVersion;
    }

    public int getMaxNumberPerMsg() {
        int ret = 1;
        StringBuilder searchString = new StringBuilder(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".maxnum");
            break;
        }
        StringBuilder tempkey = new StringBuilder();
        for (String key : this.passport.getBPD().keySet()) {
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = Integer.parseInt(this.passport.getBPD().get(key));
            break;
        }
        return ret;
    }

    protected void addConstraint(String frontendName, String destinationName, String defValue) {
        this.addConstraint(frontendName, destinationName, defValue, false);
    }

    protected void addConstraint(String frontendName, String destinationName, String defValue, boolean indexed) {
        String[] value = new String[]{this.getName() + "." + destinationName, defValue};
        String[][] values = this.constraints.get(frontendName);
        if (values == null) {
            values = new String[][]{value};
        } else {
            ArrayList a = new ArrayList(Arrays.asList(values));
            a.add(value);
            values = (String[][])a.toArray((T[])values);
        }
        this.constraints.put(frontendName, values);
        if (indexed) {
            this.indexedConstraints.add(frontendName);
        }
    }

    public void verifyConstraints() {
        for (Map.Entry<String, String[][]> entry : this.constraints.entrySet()) {
            for (String[] value : entry.getValue()) {
                String destination = value[0];
                String defValue = value[1];
                String givenContent = this.getLowlevelParam(destination);
                if (givenContent == null && this.indexedConstraints.contains(entry.getKey())) {
                    givenContent = this.getLowlevelParam(this.insertIndex(destination, 0));
                }
                String content = defValue;
                if (givenContent != null && givenContent.length() != 0) {
                    content = givenContent;
                }
                if (content == null) {
                    String msg = HBCIUtils.getLocMsg("EXC_MISSING_HL_PROPERTY", entry.getKey());
                    throw new InvalidUserDataException(msg);
                }
                if (content.length() == 0 || givenContent != null) continue;
                this.setLowlevelParam(destination, content);
            }
        }
        try {
            SEG seg = this.createJobSegment();
            seg.validate();
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** the job segment for this task can not be created", ex);
        }
    }

    private SEG createJobSegment() {
        return this.createJobSegment(0);
    }

    private SEG createJobSegment(int segnum) {
        SEG seg;
        try {
            seg = new SEG(this.getName(), this.getName(), null, 0, this.passport.getSyntaxDocument());
            this.getLowlevelParams().forEach((key, value) -> seg.propagateValue((String)key, (String)value, true, false));
            seg.propagateValue(this.getName() + ".SegHead.seq", Integer.toString(segnum), false, true);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** the job segment for this task can not be created", ex);
        }
        return seg;
    }

    public Map<String, String> getJobRestrictions() {
        return this.passport.getJobRestrictions(this.name);
    }

    public void setParam(String paramname, Konto acc) {
        this.setParam(paramname, null, acc);
    }

    public void setParam(String paramname, Integer index, Konto acc) {
        if (this.acceptsParam(paramname + ".country") && acc.country != null && acc.country.length() != 0) {
            this.setParam(paramname + ".country", index, acc.country);
        }
        if (this.acceptsParam(paramname + ".blz") && acc.blz != null && acc.blz.length() != 0) {
            this.setParam(paramname + ".blz", index, acc.blz);
        }
        if (this.acceptsParam(paramname + ".number") && acc.number != null && acc.number.length() != 0) {
            this.setParam(paramname + ".number", index, acc.number);
        }
        if (this.acceptsParam(paramname + ".subnumber") && acc.subnumber != null && acc.subnumber.length() != 0) {
            this.setParam(paramname + ".subnumber", index, acc.subnumber);
        }
        if (this.acceptsParam(paramname + ".name") && acc.name != null && acc.name.length() != 0) {
            this.setParam(paramname + ".name", index, acc.name);
        }
        if (this.acceptsParam(paramname + ".curr") && acc.curr != null && acc.curr.length() != 0) {
            this.setParam(paramname + ".curr", index, acc.curr);
        }
        if (this.acceptsParam(paramname + ".bic") && acc.bic != null && acc.bic.length() != 0) {
            this.setParam(paramname + ".bic", index, acc.bic);
        }
        if (this.acceptsParam(paramname + ".iban") && acc.iban != null && acc.iban.length() != 0) {
            this.setParam(paramname + ".iban", index, acc.iban);
        }
    }

    public void setParam(String paramname, Value v) {
        this.setParam(paramname, null, v);
    }

    public void setParam(String paramname, Integer index, Value v) {
        if (this.acceptsParam(paramname + ".value")) {
            this.setParam(paramname + ".value", index, HBCIUtils.bigDecimal2String(v.getBigDecimalValue()));
        }
        String curr = v.getCurr();
        if (this.acceptsParam(paramname + ".curr") && curr != null && curr.length() != 0) {
            this.setParam(paramname + ".curr", index, curr);
        }
    }

    public void setParam(String paramName, Date date) {
        this.setParam(paramName, null, date);
    }

    public void setParam(String paramName, Integer index, Date date) {
        this.setParam(paramName, index, HBCIUtils.date2StringISO(date));
    }

    public void setParam(String paramName, int i) {
        this.setParam(paramName, Integer.toString(i));
    }

    boolean acceptsParam(String hlParamName) {
        return this.constraints.get(hlParamName) != null;
    }

    public void setParam(String paramName, String value) {
        this.setParam(paramName, null, value);
    }

    public void setParam(String paramName, Integer index, String value) {
        String[][] destinations = this.constraints.get(paramName);
        if (destinations == null) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_NOTNEEDED", new String[]{paramName, this.getName()});
            throw new InvalidUserDataException(msg);
        }
        if (value == null || value.length() == 0) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_EMPTY", new String[]{paramName, this.getName()});
            throw new InvalidUserDataException(msg);
        }
        if (index != null && !this.indexedConstraints.contains(paramName)) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_NOTINDEXED", new String[]{paramName, this.getName()});
            throw new InvalidUserDataException(msg);
        }
        for (String[] valuePair : destinations) {
            String lowlevelname = valuePair[0];
            if (index != null && this.indexedConstraints.contains(paramName)) {
                lowlevelname = this.insertIndex(lowlevelname, index);
            }
            this.setLowlevelParam(lowlevelname, value);
        }
    }

    public void applyOffset() {
        String offset = this.getContinueOffset();
        this.setLowlevelParam(this.getName() + ".offset", offset != null ? offset : "");
    }

    public void setLowlevelParam(String key, String value) {
        log.debug("setting lowlevel parameter " + key + " = " + value);
        this.llParams.put(key, value);
    }

    public Map<String, String> getLowlevelParams() {
        return this.llParams;
    }

    public String getLowlevelParam(String key) {
        return this.getLowlevelParams().get(key);
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public String getName() {
        return this.name;
    }

    public int getSegVersion() {
        return this.segVersion;
    }

    public void setSegVersion(int version) {
        String[] names;
        if (version < 1) {
            log.warn("tried to change segment version for task " + this.jobName + " explicit, but no version given");
            return;
        }
        if (version == this.segVersion) {
            return;
        }
        log.info("changing segment version for task " + this.jobName + " explicit from " + this.segVersion + " to " + version);
        String oldName = this.name;
        this.segVersion = version;
        this.name = this.jobName + version;
        for (String s : names = this.llParams.keySet().toArray(new String[0])) {
            if (!s.startsWith(oldName)) continue;
            String value = this.llParams.get(s);
            String newName = s.replaceFirst(oldName, this.name);
            this.llParams.remove(s);
            this.llParams.put(newName, value);
        }
        this.constraints.forEach((frontendName, values) -> {
            for (String[] value : values) {
                if (!value[0].startsWith(oldName)) continue;
                value[0] = value[0].replaceFirst(oldName, this.name);
            }
        });
    }

    public AbstractHBCIJob redo() {
        return this.getContinueOffset() != null ? this : null;
    }

    private String getContinueOffset() {
        HBCIRetVal ret = this.getW3040(this.loopCount);
        return ret != null ? ret.params[0] : null;
    }

    private HBCIRetVal getW3040(int loop) {
        int num = this.jobResult.getResultsSize();
        for (int i = 0; i < num; ++i) {
            HBCIRetVal retval = this.jobResult.getRetVal(i);
            if (!KnownReturncode.W3040.is(retval.code) || retval.params.length == 0 || --loop != 0) continue;
            return retval;
        }
        return null;
    }

    public void addLoop() {
        ++this.loopCount;
    }

    public void fillJobResult(HBCIMsgStatus status, int offset) {
        try {
            this.skip = false;
            ++this.loopCount;
            HashMap<String, String> result = status.getData();
            HashMap keyHeaders = new HashMap();
            status.getData().keySet().forEach(key -> {
                String segref;
                if (key.startsWith("GVRes") && key.endsWith(".SegHead.ref") && Integer.parseInt(segref = (String)result.get(key)) - offset == this.idx) {
                    int resnum = 0;
                    if (key.startsWith("GVRes_")) {
                        resnum = Integer.parseInt(key.substring(key.indexOf(95) + 1, key.indexOf(46)));
                    }
                    keyHeaders.put(new Integer(resnum), key.substring(0, key.length() - ".SegHead.ref".length()));
                }
            });
            this.saveBasicValues(result, this.idx + offset);
            this.saveReturnValues(status, this.idx + offset);
            Object[] resnums = keyHeaders.keySet().toArray(new Object[0]);
            Arrays.sort(resnums);
            for (Object resnum : resnums) {
                String header = (String)keyHeaders.get(resnum);
                this.extractPlaintextResults(status, header, this.contentCounter);
                this.extractResults(status, header, this.contentCounter++);
            }
        }
        catch (Exception e) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_CANTSTORERES", this.getName());
            throw new HBCI_Exception(msg, e);
        }
    }

    private void saveBasicValues(HashMap<String, String> result, int ref) {
        if (this.jobResult.getDialogId() == null) {
            String msgheadName = "orig_" + result.get("1");
            this.jobResult.storeResult("basic.dialogid", result.get(msgheadName + ".dialogid"));
            this.jobResult.storeResult("basic.msgnum", result.get(msgheadName + ".msgnum"));
            this.jobResult.storeResult("basic.segnum", Integer.toString(ref));
            log.debug("basic values for " + this.getName() + " set to " + this.jobResult.getDialogId() + "/" + this.jobResult.getMsgNum() + "/" + this.jobResult.getSegNum());
        }
    }

    private void saveReturnValues(HBCIMsgStatus status, int sref) {
        List<HBCIRetVal> retVals = status.segStatus.getRetVals();
        String segref = Integer.toString(sref);
        retVals.forEach(retVal -> {
            if (retVal.segref != null && retVal.segref.equals(segref)) {
                this.jobResult.jobStatus.addRetVal((HBCIRetVal)retVal);
            }
        });
        this.jobResult.globStatus = status.globStatus;
    }

    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
    }

    private void extractPlaintextResults(HBCIMsgStatus status, String header, int idx) {
        HashMap<String, String> result = status.getData();
        result.keySet().forEach(key -> {
            if (key.startsWith(header + ".")) {
                this.jobResult.storeResult(HBCIUtils.withCounter("content", idx) + "." + key.substring(header.length() + 1), (String)result.get(key));
            }
        });
    }

    public HBCIJobResult getJobResult() {
        return this.jobResult;
    }

    private void checkAccountCRCInternal(String frontendname, String blz, String number) {
        String oldNumber;
        String oldBlz;
        if (blz == null || number == null) {
            return;
        }
        if (blz.length() == 0 || number.length() == 0) {
            return;
        }
        String origBlz = blz;
        String origNumber = number;
        do {
            boolean crcok = HBCIUtils.checkAccountCRC(blz, number);
            oldBlz = blz;
            oldNumber = number;
            if (crcok) continue;
            StringBuilder sb = new StringBuilder(blz).append("|").append(number);
            this.passport.getCallback().callback(19, Collections.singletonList(HBCIUtils.getLocMsg("CALLB_HAVE_CRC_ERROR")), 2, sb);
            int idx = sb.indexOf("|");
            blz = sb.substring(0, idx);
            number = sb.substring(idx + 1);
        } while (!blz.equals(oldBlz) || !number.equals(oldNumber));
        if (!blz.equals(origBlz)) {
            this.setParam(frontendname + ".KIK.blz", blz);
        }
        if (!number.equals(origNumber)) {
            this.setParam(frontendname + ".number", number);
        }
    }

    private void checkIBANCRCInternal(String frontendname, String iban) {
        String oldIban;
        if (iban == null || iban.length() == 0) {
            return;
        }
        String origIban = iban;
        do {
            boolean crcok = HBCIUtils.checkIBANCRC(iban);
            oldIban = iban;
            if (crcok) continue;
            StringBuilder sb = new StringBuilder(iban);
            this.passport.getCallback().callback(30, Collections.singletonList(HBCIUtils.getLocMsg("CALLB_HAVE_IBAN_ERROR")), 2, sb);
            iban = sb.toString();
        } while (!iban.equals(oldIban));
        if (!iban.equals(origIban)) {
            this.setParam(frontendname + ".iban", iban);
        }
    }

    protected void checkAccountCRC(String frontendname) {
        String[][] data2;
        String[][] data = this.constraints.get(frontendname + ".blz");
        if (data != null && data.length != 0) {
            String paramname = data[0][0];
            String lowlevelHeader = paramname.substring(0, paramname.lastIndexOf(".KIK.blz"));
            String blz = this.llParams.get(lowlevelHeader + ".KIK.blz");
            String number = this.llParams.get(lowlevelHeader + ".number");
            this.checkAccountCRCInternal(frontendname, blz, number);
        }
        if ((data2 = this.constraints.get(frontendname + ".iban")) != null && data2.length != 0) {
            String paramname = data2[0][0];
            String lowlevelHeader = paramname.substring(0, paramname.lastIndexOf(".iban"));
            String iban = this.llParams.get(lowlevelHeader + ".iban");
            this.checkIBANCRCInternal(frontendname, iban);
        }
    }

    public String getChallengeParam(String path) {
        String result;
        if (path.equals("SegHead.code")) {
            result = this.getHBCICode();
        } else {
            String valuePath = this.getName() + "." + path;
            result = this.getLowlevelParam(valuePath);
        }
        return result;
    }

    boolean twoDigitValueInList(String value, String list) {
        boolean found = false;
        int len = list.length();
        if ((len & 1) != 0) {
            throw new InvalidArgumentException("list must have 2*n digits");
        }
        if (value.length() != 2) {
            throw new InvalidArgumentException("value must have 2 digits");
        }
        for (int i = 0; i < len; i += 2) {
            String x = list.substring(i, i + 2);
            if (!value.equals(x)) continue;
            found = true;
            break;
        }
        return found;
    }

    private String insertIndex(String key, Integer index) {
        Matcher m;
        if (index != null && (m = INDEX_PATTERN.matcher(key)).matches()) {
            return m.group(1) + '[' + index + ']' + (m.group(2) != null ? m.group(2) : "");
        }
        return key;
    }

    public String createOrderHash(int segVersion) {
        SEG seg = this.createJobSegment(3);
        seg.validate();
        String segdata = seg.toString(0);
        log.debug("calculating hash for jobsegment: " + segdata);
        String alg = null;
        String provider = null;
        String orderhashmode = this.passport.getOrderHashMode(segVersion);
        if (orderhashmode.equals("1")) {
            alg = "RIPEMD160";
            provider = "CryptAlgs4Java";
        } else if (orderhashmode.equals("2")) {
            alg = "SHA-1";
        }
        log.debug("using " + alg + "/" + provider + " for generating order hash");
        try {
            MessageDigest digest = MessageDigest.getInstance(alg, provider);
            digest.update(segdata.getBytes(CommPinTan.ENCODING));
            return new String(digest.digest(), CommPinTan.ENCODING);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, String[][]> getConstraints() {
        return this.constraints;
    }

    public String getRawData() {
        return null;
    }

    public SepaVersion getPainVersion() {
        return null;
    }

    public boolean skipped() {
        return this.skip;
    }

    public void setVeu(boolean veu) {
        this.veu = veu;
    }

    public boolean isVeu() {
        return this.veu;
    }
}

