/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.HashMap;
import java.util.Optional;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCIUpdDialog
extends AbstractHbciDialog {
    private static final Logger log = LoggerFactory.getLogger(HBCIUpdDialog.class);
    private boolean withHktan;

    public HBCIUpdDialog(PinTanPassport passport, boolean withHktan) {
        super(passport);
        this.withHktan = withHktan;
    }

    @Override
    public HBCIExecStatus execute(boolean close) {
        try {
            log.debug("registering user");
            this.updateUserData();
            if (close) {
                this.dialogEnd();
            }
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
        }
        return null;
    }

    @Override
    public long getMsgnum() {
        return 2L;
    }

    private void fetchSysId() {
        HBCIMsgStatus syncStatus = null;
        try {
            this.passport.getCallback().status(9, null);
            log.info("fetching new sys-id from institute");
            this.passport.setSigId(1L);
            this.passport.setSysId("0");
            if (this.withHktan) {
                this.withHktan = Optional.ofNullable(this.passport.getCurrentSecMechInfo()).map(twoStepMechanism -> !twoStepMechanism.getId().equals("999")).orElse(false);
            }
            if (!(syncStatus = this.doDialogInitSync("0", this.withHktan)).isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), syncStatus);
            }
            this.passport.updateUPD(syncStatus.getData());
            this.passport.updateBPD(syncStatus.getData());
            this.passport.setSysId(syncStatus.getData().get("SyncRes.sysid"));
            this.passport.getCallback().status(10, new Object[]{syncStatus, this.passport.getSysId()});
            log.debug("new sys-id is " + this.passport.getSysId());
            this.dialogId = syncStatus.getData().get("MsgHead.dialogid");
            if (syncStatus != null) {
                this.passport.postInitResponseHook(syncStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (syncStatus != null) {
                    this.passport.postInitResponseHook(syncStatus);
                }
                throw throwable;
            }
        }
    }

    private void fetchSigId() {
        HBCIMsgStatus msgStatus = null;
        try {
            this.passport.getCallback().status(15, null);
            log.info("syncing signature id");
            this.passport.setSigId(9999999999999999L);
            msgStatus = this.doDialogInitSync("2", true);
            if (!msgStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), msgStatus);
            }
            HashMap<String, String> syncResult = msgStatus.getData();
            this.passport.updateUPD(syncResult);
            this.passport.setSigId(syncResult.get("SyncRes.sigid") != null ? Long.parseLong(syncResult.get("SyncRes.sigid")) : 1L);
            this.passport.incSigId();
            this.passport.getCallback().status(16, new Object[]{msgStatus, this.passport.getSigId()});
            log.debug("signature id set to " + this.passport.getSigId());
            this.dialogId = syncResult.get("MsgHead.dialogid");
            if (msgStatus != null) {
                this.passport.postInitResponseHook(msgStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (msgStatus != null) {
                    this.passport.postInitResponseHook(msgStatus);
                }
                throw throwable;
            }
        }
    }

    private HBCIMsgStatus doDialogInitSync(String syncMode, boolean withHktan) {
        Message message = MessageFactory.createDialogInit("Synch", syncMode, this.passport, withHktan, "HKIDN");
        return this.kernel.rawDoIt(message, null, true, true);
    }

    private void updateUserData() {
        if (this.passport.getSysId().equals("0")) {
            this.fetchSysId();
        }
        if (this.passport.getSigId() == -1L) {
            this.fetchSigId();
        }
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public void setWithHktan(boolean withHktan) {
        this.withHktan = withHktan;
    }
}

