/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIBpdDialog
extends AbstractHbciDialog {
    private static final Logger log = LoggerFactory.getLogger(HBCIBpdDialog.class);
    private static final String maxAge = "7";

    public HBCIBpdDialog(PinTanPassport passport) {
        super(passport);
    }

    @Override
    public HBCIExecStatus execute(boolean close) {
        try {
            log.debug("fetch bpd anonymous");
            HBCIMsgStatus hbciMsgStatus = this.fetchBPDAnonymousInternal();
            if (close) {
                this.dialogEnd();
            }
            return new HBCIExecStatus(Collections.singletonList(hbciMsgStatus));
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_INST"), ex);
        }
    }

    @Override
    public long getMsgnum() {
        return 2L;
    }

    private boolean isBPDExpired() {
        Map<String, String> bpd = this.passport.getBPD();
        log.info("[BPD] max age: 7 days");
        long maxMillis = -1L;
        try {
            int days = Integer.parseInt(maxAge);
            if (days == 0) {
                log.info("[BPD] auto-expiry disabled");
                return false;
            }
            if (days > 0) {
                maxMillis = (long)(days * 24 * 60 * 60) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        long lastUpdate = 0L;
        if (bpd != null) {
            String lastUpdateProperty = bpd.get("_lastupdate");
            try {
                lastUpdate = lastUpdateProperty != null ? Long.parseLong(lastUpdateProperty) : lastUpdate;
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
            log.info("[BPD] last update: " + (lastUpdate == 0L ? "never" : new Date(lastUpdate)));
        }
        long now = System.currentTimeMillis();
        if (maxMillis < 0L || now - lastUpdate > maxMillis) {
            log.info("[BPD] expired, will be updated now");
            return true;
        }
        return false;
    }

    private HBCIMsgStatus fetchBPDAnonymousInternal() {
        HBCIMsgStatus msgStatus = null;
        Map<String, String> bpd = this.passport.getBPD();
        String hbciVersionOfBPD = bpd != null ? bpd.get("_hbciversion") : null;
        String version = this.passport.getBPDVersion();
        if (version.equals("0") || this.isBPDExpired() || hbciVersionOfBPD == null || !hbciVersionOfBPD.equals(this.passport.getHBCIVersion())) {
            try {
                if (!version.equals("0")) {
                    log.info("resetting BPD version from " + version + " to 0");
                    this.passport.getBPD().put("BPA.version", "0");
                }
                this.passport.getCallback().status(3, null);
                log.info("fetching BPD");
                msgStatus = this.anonymousDialogInit();
                this.dialogId = msgStatus.getData().get("MsgHead.dialogid");
                this.passport.updateBPD(msgStatus.getData());
                if (!msgStatus.isOK()) {
                    log.error("fetching BPD failed");
                    throw new ProcessException(HBCIUtils.getLocMsg("ERR_INST_BPDFAILED"), msgStatus);
                }
                return msgStatus;
            }
            catch (HBCI_Exception e) {
                if (e.isFatal()) {
                    throw e;
                }
            }
            catch (Exception e) {
                log.info("FAILED! - maybe this institute does not support anonymous logins");
                log.info("we will nevertheless go on");
            }
        }
        log.debug("checking if requested hbci parameters are supported");
        if (this.passport.getBPD() != null) {
            if (!Arrays.asList(this.passport.getSuppVersions()).contains(this.passport.getHBCIVersion())) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_VERSIONNOTSUPP");
                throw new InvalidUserDataException(msg);
            }
        } else {
            log.warn("can not check if requested parameters are supported");
        }
        return msgStatus;
    }

    private HBCIMsgStatus anonymousDialogInit() {
        Message dialogInitMessage = MessageFactory.createAnonymousDialogInit(this.passport);
        return this.kernel.rawDoIt(dialogInitMessage, null, false, false);
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }
}

