/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRTANList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTANList
extends AbstractHBCIJob {
    public GVTANList(HBCIPassportInternal passport) {
        super(passport, GVTANList.getLowlevelName(), new GVRTANList(passport));
    }

    public static String getLowlevelName() {
        return "TANListList";
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String tanheader;
        HashMap<String, String> result = msgstatus.getData();
        GVRTANList.TANList list = new GVRTANList.TANList();
        list.status = result.get(header + ".liststatus").charAt(0);
        list.number = result.get(header + ".listnumber");
        String st = result.get(header + ".date");
        if (st != null) {
            list.date = HBCIUtils.string2DateISO(st);
        }
        String noftansperlist = result.get(header + ".noftansperlist") != null ? result.get(header + ".noftansperlist") : "0";
        String nofusedtansperlist = result.get(header + ".nofusedtansperlist") != null ? result.get(header + ".nofusedtansperlist") : "0";
        list.nofTANsPerList = Integer.parseInt(noftansperlist);
        list.nofUsedTANsPerList = Integer.parseInt(nofusedtansperlist);
        int i = 0;
        while ((st = result.get((tanheader = HBCIUtils.withCounter(header + ".TANInfo", i)) + ".usagecode")) != null) {
            GVRTANList.TANInfo info = new GVRTANList.TANInfo();
            info.usagecode = Integer.parseInt(st);
            info.usagetxt = result.get(tanheader + ".usagetxt");
            info.tan = result.get(tanheader + ".tan");
            String usagedate = result.get(tanheader + ".usagedate");
            String usagetime = result.get(tanheader + ".usagetime");
            if (usagedate != null) {
                info.timestamp = usagetime == null ? HBCIUtils.string2DateISO(usagedate) : HBCIUtils.strings2DateTimeISO(usagedate, usagetime);
            }
            list.addTANInfo(info);
            ++i;
        }
        ((GVRTANList)this.jobResult).addTANList(list);
    }
}

