/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.CurrencyAndAmountSDD;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.DirectDebitTransactionInformationSDD;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.Document;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.Pain00800101;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.PaymentInstructionInformationSDD;
import org.kapott.hbci.sepa.jaxb.pain_008_002_01.PurposeSDD;

public class ParsePain00800201
extends AbstractSepaParser<List<HashMap<String, String>>> {
    @Override
    public void parse(InputStream xml, List<HashMap<String, String>> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        Pain00800101 pain = doc.getPain00800101();
        if (pain == null) {
            return;
        }
        List<PaymentInstructionInformationSDD> pmtInfs = pain.getPmtInf();
        for (PaymentInstructionInformationSDD pmtInf : pmtInfs) {
            List<DirectDebitTransactionInformationSDD> txList = pmtInf.getDrctDbtTxInf();
            for (DirectDebitTransactionInformationSDD tx : txList) {
                XMLGregorianCalendar date;
                PurposeSDD purp;
                HashMap<String, String> prop = new HashMap<String, String>();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getCdtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getCdtrAgt().getFinInstnId().getBIC());
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getDbtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getDbtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.DST_BIC, tx.getDbtrAgt().getFinInstnId().getBIC());
                CurrencyAndAmountSDD amt = tx.getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy().value());
                if (tx.getRmtInf() != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdColltnDt()) != null) {
                    this.put(prop, ISEPAParser.Names.TARGETDATE, SepaUtil.format(date, null));
                }
                this.put(prop, ISEPAParser.Names.ENDTOENDID, tx.getPmtId().getEndToEndId());
                this.put(prop, ISEPAParser.Names.CREDITORID, tx.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthrId().getId());
                this.put(prop, ISEPAParser.Names.MANDATEID, tx.getDrctDbtTx().getMndtRltdInf().getMndtId());
                XMLGregorianCalendar mandDate = tx.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr();
                if (mandDate != null) {
                    this.put(prop, ISEPAParser.Names.MANDDATEOFSIG, SepaUtil.format(mandDate, null));
                }
                this.put(prop, ISEPAParser.Names.SEQUENCETYPE, pmtInf.getPmtTpInf().getSeqTp().value());
                this.put(prop, ISEPAParser.Names.LAST_TYPE, pmtInf.getPmtTpInf().getLclInstrm().getCd().value());
                sepaResults.add(prop);
            }
        }
    }
}

