/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import org.kapott.hbci.manager.HBCIVersion;

public class BankInfo {
    private String blz;
    private String bic;
    private String checksumMethod;
    private String location;
    private String name;
    private String pinTanAddress;
    private HBCIVersion pinTanVersion;
    private String rdhAddress;
    private HBCIVersion rdhVersion;

    static BankInfo parse(String text) {
        BankInfo info = new BankInfo();
        if (text == null || text.length() == 0) {
            return info;
        }
        String[] cols = text.split("\\|");
        info.setName(BankInfo.getValue(cols, 0));
        info.setLocation(BankInfo.getValue(cols, 1));
        info.setBic(BankInfo.getValue(cols, 2));
        info.setChecksumMethod(BankInfo.getValue(cols, 3));
        info.setRdhAddress(BankInfo.getValue(cols, 4));
        info.setPinTanAddress(BankInfo.getValue(cols, 5));
        info.setRdhVersion(HBCIVersion.byId(BankInfo.getValue(cols, 6)));
        info.setPinTanVersion(HBCIVersion.byId(BankInfo.getValue(cols, 7)));
        return info;
    }

    private static String getValue(String[] cols, int idx) {
        if (cols == null || idx >= cols.length) {
            return null;
        }
        return cols[idx];
    }

    public String getBlz() {
        return this.blz;
    }

    public void setBlz(String blz) {
        this.blz = blz;
    }

    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public String getChecksumMethod() {
        return this.checksumMethod;
    }

    public void setChecksumMethod(String checksumMethod) {
        this.checksumMethod = checksumMethod;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPinTanAddress() {
        return this.pinTanAddress;
    }

    public void setPinTanAddress(String pinTanAddress) {
        this.pinTanAddress = pinTanAddress;
    }

    public HBCIVersion getPinTanVersion() {
        return this.pinTanVersion;
    }

    public void setPinTanVersion(HBCIVersion pinTanVersion) {
        this.pinTanVersion = pinTanVersion;
    }

    public String getRdhAddress() {
        return this.rdhAddress;
    }

    public void setRdhAddress(String rdhAddress) {
        this.rdhAddress = rdhAddress;
    }

    public HBCIVersion getRdhVersion() {
        return this.rdhVersion;
    }

    public void setRdhVersion(HBCIVersion rdhVersion) {
        this.rdhVersion = rdhVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.blz);
        sb.append(": ");
        sb.append(this.name);
        return sb.toString();
    }
}

