/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIRetVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIStatus {
    private static final Logger log = LoggerFactory.getLogger(HBCIStatus.class);
    public static final int STATUS_UNKNOWN = 1;
    public static final int STATUS_ERR = 2;
    static final int STATUS_OK = 0;
    private List<HBCIRetVal> retVals = new ArrayList<HBCIRetVal>();
    private List<Exception> exceptions = new ArrayList<Exception>();

    void addException(Exception e) {
        this.exceptions.add(e);
        log.error(e.getMessage(), (Throwable)e);
    }

    public void addRetVal(HBCIRetVal ret) {
        this.retVals.add(ret);
        if (ret.isError()) {
            log.error("HBCI error code: " + ret.toString());
        }
    }

    boolean hasExceptions() {
        return this.exceptions.size() != 0;
    }

    private boolean hasX(char code) {
        boolean ret = false;
        for (HBCIRetVal retVal : this.retVals) {
            if (retVal.code.charAt(0) != code) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean hasErrors() {
        return this.hasX('9');
    }

    private boolean hasWarnings() {
        return this.hasX('3');
    }

    private boolean hasSuccess() {
        return this.hasX('0');
    }

    private List<HBCIRetVal> getX(char code) {
        ArrayList<HBCIRetVal> hbciRetVals = new ArrayList<HBCIRetVal>();
        for (HBCIRetVal retVal : this.retVals) {
            if (retVal.code.charAt(0) != code) continue;
            hbciRetVals.add(retVal);
        }
        return hbciRetVals;
    }

    public Exception[] getExceptions() {
        return this.exceptions.toArray(new Exception[0]);
    }

    public List<HBCIRetVal> getRetVals() {
        return this.retVals;
    }

    List<HBCIRetVal> getErrors() {
        return this.getX('9');
    }

    public List<HBCIRetVal> getWarnings() {
        return this.getX('3');
    }

    private List<HBCIRetVal> getSuccess() {
        return this.getX('0');
    }

    public int getStatusCode() {
        int code = this.hasExceptions() || this.hasErrors() ? 2 : (this.hasSuccess() || this.hasWarnings() ? 0 : 1);
        return code;
    }

    public boolean isOK() {
        return this.getStatusCode() == 0;
    }

    public List<String> getErrorList() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.hasExceptions()) {
            for (Exception ex : this.exceptions) {
                ret.add(HBCIUtils.exception2StringShort(ex));
            }
        }
        if (this.hasErrors()) {
            for (HBCIRetVal hbciRetVal : this.getErrors()) {
                ret.add(hbciRetVal.toString());
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (Exception ex : this.exceptions) {
            ret.append(HBCIUtils.exception2StringShort(ex));
            ret.append(System.getProperty("line.separator"));
        }
        for (HBCIRetVal hbciRetVal : this.getErrors()) {
            ret.append(hbciRetVal.toString());
            ret.append(System.getProperty("line.separator"));
        }
        for (HBCIRetVal hbciRetVal : this.getWarnings()) {
            ret.append(hbciRetVal.toString());
            ret.append(System.getProperty("line.separator"));
        }
        for (HBCIRetVal hbciRetVal : this.getSuccess()) {
            ret.append(hbciRetVal.toString());
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }
}

