/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HHDVersion {
    QR_1_3(Type.QRCODE, "HHD1\\.3\\..*?QR", null, -1, "hhd13"),
    QR_1_4(Type.QRCODE, "Q1S.*", null, -1, "hhd14"),
    HHD_1_4(Type.CHIPTAN, "HHD1\\.4.*", "1.4", 5, "hhd14"),
    HHD_1_3(Type.CHIPTAN, "HHD1\\.3.*", "1.3", 4, "hhd13"),
    MS_1(Type.PHOTOTAN, "MS1.*", null, -1, "hhd14"),
    HHD_1_2(Type.CHIPTAN, null, null, -1, "hhd12");

    private static final Logger log;
    private Type type = null;
    private String idMatch = null;
    private String versionStart = null;
    private int segVersion = 0;
    private String challengeVersion = null;

    private HHDVersion(Type type, String idMatch, String versionStart, int segVersion, String challengeVersion) {
        this.type = type;
        this.idMatch = idMatch;
        this.versionStart = versionStart;
        this.segVersion = segVersion;
        this.challengeVersion = challengeVersion;
    }

    public static HHDVersion find(HBCITwoStepMechanism secmech) {
        log.debug("trying to determine HHD version for secmech: " + secmech);
        String id = secmech.getId();
        log.debug("  technical HHD id: " + id);
        for (HHDVersion v : HHDVersion.values()) {
            String s = v.idMatch;
            if (s == null || id == null || !id.matches(s)) continue;
            log.debug("  identified as " + (Object)((Object)v));
            return v;
        }
        String version = secmech.getZkamethod_version();
        log.debug("  ZKA version: " + version);
        if (version != null && version.length() > 0) {
            for (HHDVersion v : HHDVersion.values()) {
                String s = v.versionStart;
                if (s == null || !version.startsWith(s)) continue;
                log.debug("  identified as " + (Object)((Object)v));
                return v;
            }
        }
        int segversion = secmech.getSegversion();
        log.debug("  segment version: " + segversion);
        for (HHDVersion v : HHDVersion.values()) {
            int i2 = v.segVersion;
            if (i2 <= 0 || segversion != i2) continue;
            log.debug("  identified as " + (Object)((Object)v));
            return v;
        }
        HHDVersion v = HHD_1_2;
        log.debug("  identified as " + (Object)((Object)v));
        return v;
    }

    public String getChallengeVersion() {
        return this.challengeVersion;
    }

    public Type getType() {
        return this.type;
    }

    static {
        log = LoggerFactory.getLogger(HHDVersion.class);
    }

    public static enum Type {
        CHIPTAN,
        PHOTOTAN,
        QRCODE;

    }
}

