/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVRDauerList
extends HBCIJobResultImpl {
    private List<Dauer> entries = new ArrayList<Dauer>();

    public GVRDauerList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(Dauer entry) {
        this.entries.add(entry);
    }

    public Dauer[] getEntries() {
        return this.entries.toArray(new Dauer[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator<Dauer> i = this.entries.iterator();
        while (i.hasNext()) {
            ret.append(HBCIUtils.getLocMsg("STANDINGORDER")).append(" #").append(i).append(System.getProperty("line.separator"));
            ret.append(i.next()).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }

    public static final class Dauer {
        public Konto my;
        public Konto other;
        public Value value;
        public String key;
        public String addkey;
        public String[] usage = new String[0];
        public Date nextdate;
        public String orderid;
        public Date firstdate;
        public String timeunit;
        public int turnus;
        public int execday;
        public Date lastdate;
        public boolean aus_available;
        public boolean aus_annual;
        public Date aus_start;
        public Date aus_end;
        public String aus_breakcount;
        public Value aus_newvalue;
        public boolean can_change;
        public boolean can_skip;
        public boolean can_delete;
        public String pmtinfid;
        public String purposecode;

        public void addUsage(String line) {
            ArrayList<String> a = new ArrayList<String>(Arrays.asList(this.usage));
            a.add(line);
            this.usage = a.toArray(this.usage);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("  ").append(HBCIUtils.getLocMsg("SRCACCOUNT")).append(": ").append(this.my.toString()).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("DSTACCOUNT")).append(": ").append(this.other.toString()).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("VALUE")).append(": ").append(this.value.toString()).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("KEY")).append(": ").append(this.key).append("/").append(this.addkey).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("USAGE")).append(":").append(linesep);
            for (int i = 0; i < this.usage.length; ++i) {
                ret.append("    ").append(this.usage[i]).append(linesep);
            }
            if (this.nextdate != null) {
                ret.append("  ").append(HBCIUtils.getLocMsg("NEXTEXECDATE")).append(": ").append(HBCIUtils.date2StringLocal(this.nextdate)).append(linesep);
            }
            ret.append("  ").append(HBCIUtils.getLocMsg("ORDERID")).append(": ").append(this.orderid).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("FIRSTLASTEXEC")).append(": ").append(HBCIUtils.date2StringLocal(this.firstdate)).append(" / ");
            ret.append(this.lastdate != null ? HBCIUtils.date2StringLocal(this.lastdate) : "N/A").append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("EXECDAY")).append(": ").append(this.execday).append(linesep);
            ret.append("  ").append(HBCIUtils.getLocMsg("UNITTURNUS")).append(": ").append(this.timeunit).append(" / ").append(this.turnus).append(linesep);
            ret.append("  (Aussetzung not yet implemented)");
            return ret.toString().trim();
        }
    }
}

