/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.GV.generators.PainGeneratorFactory;
import org.kapott.hbci.GV.generators.PainGeneratorIf;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSEPAGV
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractSEPAGV.class);
    public static final String ENDTOEND_ID_NOTPROVIDED = "NOTPROVIDED";
    final HashMap<String, String> painParams = new HashMap();
    private SepaVersion painVersion;
    private PainGeneratorIf generator = null;

    public AbstractSEPAGV(HBCIPassportInternal passport, String name) {
        super(passport, name, new HBCIJobResultImpl(passport));
        this.painVersion = this.determinePainVersion(passport, name);
    }

    public AbstractSEPAGV(HBCIPassportInternal passport, String name, HBCIJobResultImpl jobResult) {
        super(passport, name, jobResult);
        this.painVersion = this.determinePainVersion(passport, name);
    }

    protected abstract SepaVersion getDefaultPainVersion();

    protected abstract SepaVersion.Type getPainType();

    private SepaVersion determinePainVersion(HBCIPassportInternal passport, String gvName) {
        SepaVersion globalVersion = this.determinePainVersionInternal(passport, GVSEPAInfo.getLowlevelName());
        SepaVersion jobVersion = this.determinePainVersionInternal(passport, gvName);
        if (globalVersion == null && jobVersion == null) {
            SepaVersion def = this.getDefaultPainVersion();
            log.warn("unable to determine matching painVersion version, using default: " + def);
            return def;
        }
        if (jobVersion == null) {
            log.debug("have no job-specific painVersion version, using global painVersion version: " + globalVersion);
            return globalVersion;
        }
        log.debug("using job-specific painVersion version: " + jobVersion);
        return jobVersion;
    }

    private SepaVersion determinePainVersionInternal(HBCIPassportInternal passport, String gvName) {
        log.debug("searching for supported painVersion versions for GV " + gvName);
        if (!passport.jobSupported(gvName)) {
            log.debug("don't have any BPD for GV " + gvName);
            return null;
        }
        ArrayList<SepaVersion> found = new ArrayList<SepaVersion>();
        Map<String, String> props = passport.getLowlevelJobRestrictions(gvName);
        for (String key : props.keySet()) {
            if (!key.startsWith("suppformats")) continue;
            String urn = props.get(key);
            try {
                SepaVersion version = SepaVersion.byURN(urn);
                if (version.getType() != this.getPainType()) continue;
                if (!version.isSupported(this.getPainJobName())) {
                    log.debug("  unsupported " + version);
                    continue;
                }
                log.debug("  found " + version);
                found.add(version);
            }
            catch (Exception e) {
                log.warn("ignoring invalid painVersion version " + urn);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return SepaVersion.findGreatest(found);
    }

    @Override
    public void setLowlevelParam(String key, String value) {
        String intern = this.getName() + ".sepa.";
        if (key.startsWith(intern)) {
            String realKey = key.substring(intern.length());
            this.painParams.put(realKey, value);
            log.debug("setting SEPA param " + realKey + " = " + value);
        } else {
            super.setLowlevelParam(key, value);
        }
    }

    @Override
    public String getLowlevelParam(String key) {
        String result;
        String intern = this.getName() + ".sepa.";
        if (key.startsWith(intern)) {
            String realKey = key.substring(intern.length());
            result = this.getPainParam(realKey);
        } else {
            result = super.getLowlevelParam(key);
        }
        return result;
    }

    public String getPainMessageId() {
        String result = this.getPainParam("messageId");
        if (result == null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSS");
            result = format.format(new Date());
            result = result.substring(0, Math.min(result.length(), 35));
            this.setSEPAParam("messageId", result);
        }
        return result;
    }

    private PainGeneratorIf getPainGenerator() {
        if (this.generator == null) {
            try {
                this.generator = PainGeneratorFactory.get(this, this.getPainVersion());
            }
            catch (Exception e) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_JOB_CREATE_ERR", this.getPainJobName());
                throw new HBCI_Exception(msg, e);
            }
        }
        return this.generator;
    }

    @Override
    public SepaVersion getPainVersion() {
        return this.painVersion;
    }

    void setPainVersion(String version) {
        this.setLowlevelParam(this.getName() + ".sepadescr", version);
    }

    protected void createPainXml() {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        PainGeneratorIf gen = this.getPainGenerator();
        try {
            gen.generate(this.painParams, o, false);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** the _sepapain segment for this job can not be created", e);
        }
        if (o.size() == 0) {
            throw new HBCI_Exception("*** the _sepapain segment for this job can not be created");
        }
        try {
            String xml = o.toString("ISO-8859-1");
            log.debug("generated XML:\n" + xml);
            this.setParam("_sepapain", "B" + xml);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getRawData() {
        return this.getLowlevelParam(this.getName() + ".sepapain");
    }

    void setPainXml(String painXml) {
        this.setLowlevelParam(this.getName() + ".sepapain", painXml);
    }

    @Override
    protected void addConstraint(String frontendName, String destinationName, String defValue) {
        super.addConstraint(frontendName, destinationName, defValue);
        if (destinationName.startsWith("sepa.") && defValue != null) {
            this.painParams.put(frontendName, defValue);
        }
    }

    @Override
    public void verifyConstraints() {
        if (this.acceptsParam("_sepapain")) {
            this.createPainXml();
        }
        super.verifyConstraints();
    }

    private void setSEPAParam(String name, String value) {
        this.painParams.put(name, value);
    }

    private String getPainParam(String name) {
        return this.painParams.get(name);
    }

    public abstract String getPainJobName();
}

