/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractCamtParser;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.AccountReport18;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.BalanceType12Code;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.BankToCustomerAccountReportV05;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.BankTransactionCodeStructure4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.BranchAndFinancialInstitutionIdentification5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.CashAccount24;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.CashAccount25;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.CashBalance3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.DateAndDateTimeChoice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.EntryDetails6;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.EntryTransaction7;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.FinancialInstitutionIdentification8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.PartyIdentification43;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.ReportEntry7;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.TransactionAgents3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.TransactionParties3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_05.TransactionReferences3;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseCamt05200105
extends AbstractCamtParser {
    private static final Logger log = LoggerFactory.getLogger(ParseCamt05200105.class);

    @Override
    public void parse(InputStream xml, List<GVRKUms.BTag> tage) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        BankToCustomerAccountReportV05 container = doc.getBkToCstmrAcctRpt();
        if (container == null) {
            log.warn("camt document empty");
            return;
        }
        List<AccountReport18> reports = container.getRpt();
        if (reports == null || reports.size() == 0) {
            log.warn("camt document empty");
            return;
        }
        for (AccountReport18 report : reports) {
            GVRKUms.BTag tag = this.createDay(report);
            tage.add(tag);
            BigDecimal saldo = tag.start != null && tag.start.value != null ? tag.start.value.getBigDecimalValue() : BigDecimal.ZERO;
            for (ReportEntry7 entry : report.getNtry()) {
                GVRKUms.UmsLine line = this.createLine(entry, saldo);
                if (line == null) continue;
                tag.lines.add(line);
                saldo = line.saldo.value.getBigDecimalValue();
            }
        }
    }

    private GVRKUms.UmsLine createLine(ReportEntry7 entry, BigDecimal currSaldo) {
        Purpose2Choice purp;
        String[] parts;
        String code;
        ActiveOrHistoricCurrencyAndAmount amt;
        List<String> usages;
        TransactionAgents3 banks;
        TransactionParties3 other;
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        line.isSepa = true;
        line.isCamt = true;
        line.other = new Konto();
        List<EntryDetails6> details = entry.getNtryDtls();
        if (details.size() == 0) {
            return null;
        }
        EntryDetails6 detail = details.get(0);
        List<EntryTransaction7> txList = detail.getTxDtls();
        if (txList.size() == 0) {
            return null;
        }
        boolean haben = entry.getCdtDbtInd() != null && entry.getCdtDbtInd() == CreditDebitCode.CRDT;
        EntryTransaction7 tx = txList.get(0);
        TransactionReferences3 ref = tx.getRefs();
        if (ref != null) {
            line.id = this.trim(ref.getPrtry() != null && ref.getPrtry().size() > 0 ? ref.getPrtry().get(0).getRef() : null);
            line.endToEndId = this.trim(ref.getEndToEndId());
        }
        if ((other = tx.getRltdPties()) != null) {
            CashAccount24 acc = haben ? other.getDbtrAcct() : other.getCdtrAcct();
            AccountIdentification4Choice id = acc != null ? acc.getId() : null;
            line.other.iban = this.trim(id != null ? id.getIBAN() : null);
            PartyIdentification43 name = haben ? other.getDbtr() : other.getCdtr();
            line.other.name = this.trim(name != null ? name.getNm() : null);
            name = haben ? other.getUltmtDbtr() : other.getUltmtCdtr();
            line.other.name2 = this.trim(name != null ? name.getNm() : null);
        }
        if ((banks = tx.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification5 bank = haben ? banks.getDbtrAgt() : banks.getCdtrAgt();
            FinancialInstitutionIdentification8 bic = bank != null ? bank.getFinInstnId() : null;
            line.other.bic = this.trim(bank != null ? bic.getBICFI() : null);
        }
        List<String> list = usages = tx.getRmtInf() != null ? tx.getRmtInf().getUstrd() : null;
        if (usages != null && usages.size() > 0) {
            line.usage.addAll(this.trim(usages));
        }
        BigDecimal bd = (amt = entry.getAmt()).getValue() != null ? amt.getValue() : BigDecimal.ZERO;
        line.value = new Value(this.checkDebit(bd, entry.getCdtDbtInd()));
        line.value.setCurr(amt.getCcy());
        line.isStorno = entry.isRvslInd() != null ? entry.isRvslInd() : false;
        DateAndDateTimeChoice bdate = entry.getBookgDt();
        line.bdate = bdate != null ? SepaUtil.toDate(bdate.getDt()) : null;
        DateAndDateTimeChoice vdate = entry.getValDt();
        Date date = line.valuta = vdate != null ? SepaUtil.toDate(vdate.getDt()) : null;
        if (line.bdate == null) {
            line.bdate = line.valuta;
        }
        if (line.valuta == null) {
            line.valuta = line.bdate;
        }
        line.saldo = new Saldo();
        line.saldo.value = new Value(currSaldo.add(line.value.getBigDecimalValue()));
        line.saldo.value.setCurr(line.value.getCurr());
        line.saldo.timestamp = line.bdate;
        line.text = this.trim(entry.getAddtlNtryInf());
        line.customerref = this.trim(entry.getAcctSvcrRef());
        BankTransactionCodeStructure4 b = tx.getBkTxCd();
        String string = code = b != null && b.getPrtry() != null ? b.getPrtry().getCd() : null;
        if (code != null && code.contains("+") && (parts = code.split("\\+")).length == 4) {
            line.gvcode = parts[1];
            line.primanota = parts[2];
            line.addkey = parts[3];
        }
        line.purposecode = this.trim((purp = tx.getPurp()) != null ? purp.getCd() : null);
        return line;
    }

    private GVRKUms.BTag createDay(AccountReport18 report) {
        GVRKUms.BTag tag = new GVRKUms.BTag();
        tag.start = new Saldo();
        tag.end = new Saldo();
        tag.starttype = (char)70;
        tag.endtype = (char)70;
        long day = 86400000L;
        for (CashBalance3 bal : report.getBal()) {
            BalanceType12Code code = bal.getTp().getCdOrPrtry().getCd();
            if (code == BalanceType12Code.PRCD) {
                tag.start.value = new Value(this.checkDebit(bal.getAmt().getValue(), bal.getCdtDbtInd()));
                tag.start.value.setCurr(bal.getAmt().getCcy());
                tag.start.timestamp = new Date(SepaUtil.toDate(bal.getDt().getDt()).getTime() + 86400000L);
                continue;
            }
            if (code != BalanceType12Code.CLBD) continue;
            tag.end.value = new Value(this.checkDebit(bal.getAmt().getValue(), bal.getCdtDbtInd()));
            tag.end.value.setCurr(bal.getAmt().getCcy());
            tag.end.timestamp = SepaUtil.toDate(bal.getDt().getDt());
        }
        CashAccount25 acc = report.getAcct();
        tag.my = new Konto();
        tag.my.iban = this.trim(acc.getId().getIBAN());
        tag.my.curr = this.trim(acc.getCcy());
        BranchAndFinancialInstitutionIdentification5 bank = acc.getSvcr();
        if (bank != null && bank.getFinInstnId() != null) {
            tag.my.bic = this.trim(bank.getFinInstnId().getBICFI());
        }
        return tag;
    }

    private BigDecimal checkDebit(BigDecimal d, CreditDebitCode code) {
        if (d == null || code == null || code == CreditDebitCode.CRDT) {
            return d;
        }
        return BigDecimal.ZERO.subtract(d);
    }
}

