/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.swift;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DTAUS_CH {
    private static final byte ALIGN_LEFT = 1;
    private static final byte ALIGN_RIGHT = 2;
    private List<Transaction> entries;
    private Konto myAccount;
    private String[] myAddress;
    private int counter;
    private Date now;
    private long total;

    public DTAUS_CH(Konto myAccount, String[] myAddress) {
        if (!myAccount.country.equals("CH")) {
            throw new InvalidArgumentException("*** can only be used with swiss accounts");
        }
        this.entries = new ArrayList<Transaction>();
        this.myAccount = myAccount;
        this.myAddress = myAddress != null ? myAddress : new String[]{};
        this.counter = 0;
    }

    public void addEntry(Transaction entry) {
        entry.idx = ++this.counter;
        this.entries.add(entry);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        this.now = new Date();
        this.total = 0L;
        for (Transaction trans : this.entries) {
            ret.append(trans.toString());
        }
        ret.append("01");
        ret.append(this.expand("", 6, (byte)48, 1));
        ret.append(this.expand("", 12, (byte)32, 1));
        ret.append(this.expand("", 5, (byte)48, 1));
        ret.append(new SimpleDateFormat("yyMMdd").format(this.now));
        ret.append(this.expand("", 7, (byte)32, 1));
        ret.append(this.expand("", 5, (byte)32, 1));
        ret.append(this.expand(Integer.toString(this.counter + 1), 5, (byte)48, 2));
        ret.append("890");
        ret.append("00");
        ret.append(this.expand(new DecimalFormat("0.000").format((double)this.total / 100.0).replace('.', ','), 16, (byte)32, 1));
        ret.append(this.expand("", 59, (byte)32, 1));
        return ret.toString();
    }

    private String expand(String st, int len, byte filler, int align) {
        if (st.length() < len) {
            try {
                byte[] fill = new byte[len - st.length()];
                Arrays.fill(fill, filler);
                String fillst = new String(fill, "ISO-8859-1");
                if (align == 1) {
                    st = st + fillst;
                }
                if (align == 2) {
                    st = fillst + st;
                }
                throw new HBCI_Exception("*** invalid align type: " + align);
            }
            catch (Exception e) {
                throw new HBCI_Exception(e);
            }
        } else if (st.length() > len) {
            throw new InvalidArgumentException("*** string too long: \"" + st + "\" has " + st.length() + " chars, but max is " + len);
        }
        return st;
    }

    public class Transaction {
        public Konto other;
        public Value value;
        public List<String> usage;
        public int idx;

        public Transaction(Konto other, Value value) {
            this.other = other;
            this.value = value;
            this.usage = new ArrayList<String>();
        }

        public void addUsage(String st) {
            this.usage.add(st);
        }

        public String toString() {
            int i;
            StringBuffer ret = new StringBuffer();
            ret.append("01");
            ret.append(new SimpleDateFormat("yyMMdd").format(DTAUS_CH.this.now));
            ret.append(DTAUS_CH.this.expand(this.other.blz, 12, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand("", 5, (byte)48, 1));
            ret.append(new SimpleDateFormat("yyMMdd").format(DTAUS_CH.this.now));
            ret.append(DTAUS_CH.this.expand(((DTAUS_CH)DTAUS_CH.this).myAccount.blz, 7, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand("", 5, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand(Integer.toString(this.idx), 5, (byte)48, 2));
            ret.append("827");
            ret.append("00");
            ret.append(DTAUS_CH.this.expand("", 5, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand("TAN" + Integer.toString(this.idx), 11, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand(((DTAUS_CH)DTAUS_CH.this).myAccount.number, 24, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand("", 6, (byte)32, 1));
            ret.append(this.value.getCurr());
            ret.append(DTAUS_CH.this.expand(new DecimalFormat("0.00").format(this.value.getBigDecimalValue()).replace('.', ','), 12, (byte)32, 1));
            DTAUS_CH.this.total = DTAUS_CH.this.total + this.value.getLongValue();
            ret.append(DTAUS_CH.this.expand("", 14, (byte)32, 1));
            ret.append("02");
            ret.append(DTAUS_CH.this.expand(((DTAUS_CH)DTAUS_CH.this).myAccount.name, 24, (byte)32, 1));
            for (i = 0; i < 3; ++i) {
                ret.append(DTAUS_CH.this.expand(i < DTAUS_CH.this.myAddress.length ? DTAUS_CH.this.myAddress[i] : "", 24, (byte)32, 1));
            }
            ret.append(DTAUS_CH.this.expand("", 30, (byte)32, 1));
            ret.append("03");
            ret.append("/C/");
            ret.append(DTAUS_CH.this.expand(this.other.number, 27, (byte)32, 1));
            ret.append(DTAUS_CH.this.expand(this.other.name, 24, (byte)32, 1));
            for (i = 0; i < 3; ++i) {
                ret.append(DTAUS_CH.this.expand("", 24, (byte)32, 1));
            }
            ret.append("04");
            for (i = 0; i < 4; ++i) {
                ret.append(DTAUS_CH.this.expand(i < this.usage.size() ? this.usage.get(i) : "", 28, (byte)32, 1));
            }
            ret.append(DTAUS_CH.this.expand("", 14, (byte)32, 1));
            return ret.toString();
        }
    }
}

