/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public final class HBCIRetVal
implements Serializable {
    public String code;
    public String segref;
    public String deref;
    public String text;
    public String[] params;
    public String element;

    public HBCIRetVal(String segref, String deref, String element, String code, String text, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        this.code = code;
        this.segref = segref;
        this.deref = deref;
        this.text = text;
        this.params = params;
        this.element = element;
    }

    public HBCIRetVal(HashMap<String, String> result, String header) {
        this(result, header, null);
    }

    public HBCIRetVal(HashMap<String, String> result, String header, String segref) {
        String parm;
        this.segref = segref;
        this.code = result.get(header + ".code");
        if (this.code == null) {
            throw new HBCI_Exception("*** no valid error");
        }
        this.deref = result.get(header + ".ref");
        this.text = result.get(header + ".text");
        this.element = null;
        if (segref != null) {
            String path = result.get(segref + (this.deref != null ? ":" + this.deref : ""));
            String value = path != null ? result.get("orig_" + path) : null;
            this.element = path + (value != null ? "=" + value : "");
        }
        ArrayList<String> a = new ArrayList<String>();
        int i = 0;
        while ((parm = result.get(HBCIUtils.withCounter(header + ".parm", i))) != null) {
            a.add(parm);
            ++i;
        }
        this.params = new String[0];
        if (a.size() != 0) {
            this.params = a.toArray(this.params);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.code).append(":").append(this.text);
        for (int i = 0; i < this.params.length; ++i) {
            ret.append(" p:").append(this.params[i]);
        }
        if (this.segref != null) {
            ret.append(" (");
            ret.append(this.segref);
            if (this.deref != null) {
                ret.append(":");
                ret.append(this.deref);
            }
            if (this.element != null) {
                ret.append(": ");
                ret.append(this.element);
            }
            ret.append(")");
        }
        return ret.toString().trim();
    }

    public boolean isSuccess() {
        return this.code != null && this.code.charAt(0) == '0';
    }

    public boolean isWarning() {
        return this.code != null && this.code.charAt(0) == '3';
    }

    public boolean isError() {
        return this.code != null && this.code.charAt(0) == '9';
    }

    public boolean equals(Object o) {
        boolean ret;
        if (o instanceof HBCIRetVal) {
            boolean equal = true;
            HBCIRetVal other = (HBCIRetVal)o;
            equal &= this.code == null && other.code == null || this.code != null && other.code != null && this.code.equals(other.code);
            equal &= this.text == null && other.text == null || this.text != null && other.text != null && this.text.equals(other.text);
            equal &= this.segref == null && other.segref == null || this.segref != null && other.segref != null && this.segref.equals(other.segref);
            ret = equal &= this.deref == null && other.deref == null || this.deref != null && other.deref != null && this.deref.equals(other.deref);
        } else {
            ret = super.equals(o);
        }
        return ret;
    }
}

