/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.List;

public class FlickerCode {
    private static final int LC_LENGTH_HHD14 = 3;
    private static final int LC_LENGTH_HHD13 = 2;
    private static final int BIT_ENCODING = 6;
    private static final int BIT_CONTROLBYTE = 7;
    public HHDVersion version = null;
    public int lc = 0;
    public Startcode startCode = new Startcode();
    public DE de1 = new DE();
    public DE de2 = new DE();
    public DE de3 = new DE();
    public String rest = null;

    public FlickerCode() {
    }

    public FlickerCode(String code) {
        try {
            this.parse(code, HHDVersion.HHD14);
        }
        catch (Exception e) {
            this.parse(code, HHDVersion.HHD13);
        }
    }

    private static String toHex(int n, int len) {
        String s = Integer.toString(n, 16).toUpperCase();
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }

    private static String toHex(String s) {
        char[] chars;
        StringBuffer sb = new StringBuffer();
        for (char c : chars = s.toCharArray()) {
            sb.append(FlickerCode.toHex(c, 2));
        }
        return sb.toString();
    }

    private static int quersumme(int n) {
        int q = 0;
        while (n != 0) {
            q += n % 10;
            n = (int)Math.floor(n / 10);
        }
        return q;
    }

    private static int getBitSum(int num, int bits) {
        int sum = 0;
        for (int i = 0; i <= bits; ++i) {
            sum += num & 1 << i;
        }
        return sum;
    }

    private static boolean isBitSet(int num, int bit) {
        return (num & 1 << bit) != 0;
    }

    private void parse(String code, HHDVersion version) {
        this.reset();
        code = this.clean(code);
        int len = version == HHDVersion.HHD14 ? 3 : 2;
        this.lc = Integer.parseInt(code.substring(0, len));
        code = code.substring(len);
        code = this.startCode.parse(code);
        code = this.de1.parse(code);
        code = this.de2.parse(code);
        code = this.de3.parse(code);
        this.rest = code.length() > 0 ? code : null;
    }

    private String clean(String code) {
        code = code.replaceAll(" ", "");
        code = code.trim();
        int t1Start = code.indexOf("CHLGUC");
        int t2Start = code.indexOf("CHLGTEXT");
        if (t1Start == -1 || t2Start == -1 || t2Start <= t1Start) {
            return code;
        }
        code = code.substring(0, t2Start);
        code = code.substring(t1Start);
        code = code.substring(10);
        return "0" + code;
    }

    public String render() {
        String s = this.createPayload();
        String luhn = this.createLuhnChecksum();
        String xor = this.createXORChecksum(s);
        return s + luhn + xor;
    }

    private String createPayload() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.startCode.renderLength());
        for (Integer i : this.startCode.controlBytes) {
            sb.append(FlickerCode.toHex(i, 2));
        }
        sb.append(this.startCode.renderData());
        DE[] deList = new DE[]{this.de1, this.de2, this.de3};
        for (int i = 0; i < deList.length; ++i) {
            DE de = deList[i];
            sb.append(de.renderLength());
            sb.append(de.renderData());
        }
        String s = sb.toString();
        int len = s.length();
        len += 2;
        String lc = FlickerCode.toHex(len /= 2, 2);
        return lc + s;
    }

    private String createXORChecksum(String payload) {
        int xorsum = 0;
        for (int i = 0; i < payload.length(); ++i) {
            xorsum ^= Integer.parseInt(Character.toString(payload.charAt(i)), 16);
        }
        return FlickerCode.toHex(xorsum, 1);
    }

    private String createLuhnChecksum() {
        StringBuffer sb = new StringBuffer();
        for (Integer i : this.startCode.controlBytes) {
            sb.append(FlickerCode.toHex(i, 2));
        }
        sb.append(this.startCode.renderData());
        if (this.de1.data != null) {
            sb.append(this.de1.renderData());
        }
        if (this.de2.data != null) {
            sb.append(this.de2.renderData());
        }
        if (this.de3.data != null) {
            sb.append(this.de3.renderData());
        }
        String payload = sb.toString();
        int luhnsum = 0;
        int i = 0;
        for (i = 0; i < payload.length(); i += 2) {
            luhnsum += 1 * Integer.parseInt(Character.toString(payload.charAt(i)), 16) + FlickerCode.quersumme(2 * Integer.parseInt(Character.toString(payload.charAt(i + 1)), 16));
        }
        int mod = luhnsum % 10;
        if (mod == 0) {
            return "0";
        }
        int rest = 10 - mod;
        int sum = luhnsum + rest;
        int luhn = sum - luhnsum;
        return FlickerCode.toHex(luhn, 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VERSION:\n" + (Object)((Object)this.version) + "\n");
        sb.append("LC: " + this.lc + "\n");
        sb.append("Startcode:\n" + this.startCode + "\n");
        sb.append("DE1:\n" + this.de1 + "\n");
        sb.append("DE2:\n" + this.de2 + "\n");
        sb.append("DE3:\n" + this.de3 + "\n");
        sb.append("CB : " + this.rest + "\n");
        return sb.toString();
    }

    private void reset() {
        this.version = null;
        this.lc = 0;
        this.startCode = new Startcode();
        this.de1 = new DE();
        this.de2 = new DE();
        this.de3 = new DE();
        this.rest = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlickerCode)) {
            return false;
        }
        FlickerCode other = (FlickerCode)obj;
        if (this.lc != other.lc) {
            return false;
        }
        if (!this.startCode.equals(other.startCode)) {
            return false;
        }
        if (!this.de1.equals(other.de1)) {
            return false;
        }
        if (!this.de2.equals(other.de2)) {
            return false;
        }
        if (!this.de3.equals(other.de3)) {
            return false;
        }
        if (this.rest == null) {
            return other.rest == null;
        }
        return this.rest.equals(other.rest);
    }

    public class Startcode
    extends DE {
        public List<Integer> controlBytes;

        public Startcode() {
            this.controlBytes = new ArrayList<Integer>();
        }

        @Override
        String parse(String s) {
            this.lde = Integer.parseInt(s.substring(0, 2), 16);
            s = s.substring(2);
            this.length = FlickerCode.getBitSum(this.lde, 5);
            FlickerCode.this.version = HHDVersion.HHD13;
            if (FlickerCode.isBitSet(this.lde, 7)) {
                FlickerCode.this.version = HHDVersion.HHD14;
                for (int i = 0; i < 10; ++i) {
                    int controlByte = Integer.parseInt(s.substring(0, 2), 16);
                    this.controlBytes.add(controlByte);
                    s = s.substring(2);
                    if (!FlickerCode.isBitSet(controlByte, 7)) break;
                }
            }
            this.data = s.substring(0, this.length);
            s = s.substring(this.length);
            return s;
        }

        @Override
        String renderLength() {
            String s = super.renderLength();
            if (FlickerCode.this.version == HHDVersion.HHD13) {
                return s;
            }
            if (this.controlBytes.size() == 0) {
                return s;
            }
            int len = Integer.parseInt(s, 16);
            if (this.controlBytes.size() > 0) {
                len += 128;
            }
            return FlickerCode.toHex(len, 2);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append("  Controlbytes: " + this.controlBytes + "\n");
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Startcode)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    public class DE {
        public int length = 0;
        public int lde = 0;
        public Encoding encoding = null;
        public String data = null;

        String parse(String s) {
            if (s == null || s.length() == 0) {
                return s;
            }
            this.lde = Integer.parseInt(s.substring(0, 2));
            s = s.substring(2);
            this.length = FlickerCode.getBitSum(this.lde, 5);
            this.data = s.substring(0, this.length);
            s = s.substring(this.length);
            return s;
        }

        String renderLength() {
            if (this.data == null) {
                return "";
            }
            Encoding enc = this.getEncoding();
            int len = this.renderData().length() / 2;
            if (enc == Encoding.BCD) {
                return FlickerCode.toHex(len, 2);
            }
            if (FlickerCode.this.version == HHDVersion.HHD14) {
                return FlickerCode.toHex(len += 64, 2);
            }
            return "1" + FlickerCode.toHex(len, 1);
        }

        Encoding getEncoding() {
            if (this.data == null) {
                return Encoding.BCD;
            }
            if (this.encoding != null) {
                return this.encoding;
            }
            if (this.data.matches("[0-9]{1,}")) {
                return Encoding.BCD;
            }
            return Encoding.ASC;
        }

        String renderData() {
            if (this.data == null) {
                return "";
            }
            Encoding enc = this.getEncoding();
            if (enc == Encoding.ASC) {
                return FlickerCode.toHex(this.data);
            }
            String s = this.data;
            if (s.length() % 2 == 1) {
                s = s + "F";
            }
            return s;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("  Length  : " + this.length + "\n");
            sb.append("  LDE     : " + this.lde + "\n");
            sb.append("  Data    : " + this.data + "\n");
            sb.append("  Encoding: " + (Object)((Object)this.encoding) + "\n");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DE)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    public static enum Encoding {
        ASC,
        BCD;

    }

    public static enum HHDVersion {
        HHD14,
        HHD13;

    }
}

