/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;

public final class SyntaxNum
extends SyntaxDE {
    public SyntaxNum(String st, int minsize, int maxsize) {
        super(SyntaxNum.check(st), minsize, maxsize);
    }

    public SyntaxNum(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private static String check(String st) {
        try {
            new Long(st);
            StringBuffer ret = new StringBuffer(st);
            while (ret.length() != 1 && ret.charAt(0) == '0') {
                ret.deleteCharAt(0);
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_LONGERR", st), e);
        }
    }

    @Override
    public void init(String st, int minsize, int maxsize) {
        super.init(SyntaxNum.check(st), minsize, maxsize);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxNum.skipPreDelim(res);
        int endidx = SyntaxNum.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        int len = st.length();
        for (int i = 0; i < len; ++i) {
            char ch = st.charAt(i);
            if (ch <= '9' && ch >= '0' && (i != 0 || len == 1 || ch != '0')) continue;
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXC_DTNUM_INV_CHAR", st));
        }
        this.setContent(st, minsize, maxsize);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }
}

