/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Value;

public final class GVRFestCondList
extends HBCIJobResultImpl {
    private List<Cond> entries = new ArrayList<Cond>();

    public GVRFestCondList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(Cond entry) {
        this.entries.add(entry);
    }

    public Cond[] getEntries() {
        return this.entries.toArray(new Cond[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < this.entries.size(); ++i) {
            Cond entry = this.entries.get(i);
            ret.append("#").append(i).append(linesep);
            ret.append(entry.toString());
            ret.append(linesep).append(linesep);
        }
        return ret.toString().trim();
    }

    public static final class Cond {
        public static final int METHOD_30_360 = 0;
        public static final int METHOD_2831_360 = 1;
        public static final int METHOD_2831_365366 = 2;
        public static final int METHOD_30_365366 = 3;
        public static final int METHOD_2831_365 = 4;
        public static final int METHOD_30_365 = 5;
        public Date anlagedatum;
        public Date ablaufdatum;
        public long zinssatz;
        public int zinsmethode;
        public Value minbetrag;
        public Value maxbetrag;
        public String id;
        public String name;
        public String version;
        public Date date;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("Konditionen '").append(this.name).append("'");
            if (this.version != null) {
                ret.append(" V").append(this.version).append(" ").append(HBCIUtils.datetime2StringLocal(this.date));
            }
            ret.append(linesep);
            ret.append("  Zeitraum: ");
            ret.append(HBCIUtils.date2StringLocal(this.anlagedatum));
            ret.append(" bis ");
            ret.append(HBCIUtils.date2StringLocal(this.ablaufdatum));
            ret.append(linesep);
            ret.append("  Betragsintervall: ");
            ret.append(this.minbetrag.toString());
            ret.append(" bis ");
            if (this.maxbetrag != null) {
                ret.append(this.maxbetrag.toString());
            } else {
                ret.append("(unbegrenzt)");
            }
            ret.append(linesep);
            ret.append("  Zinssatz: ");
            ret.append(HBCIUtils.bigDecimal2String(new BigDecimal(this.zinssatz).divide(new BigDecimal("1000.0"))));
            ret.append("% (");
            switch (this.zinsmethode) {
                case 1: {
                    ret.append("28/31 Tage bzw. 360 Tage");
                    break;
                }
                case 4: {
                    ret.append("28/31 Tage bzw. 365 Tage");
                    break;
                }
                case 2: {
                    ret.append("28/31 Tage bzw. 365/366 Tage");
                    break;
                }
                case 0: {
                    ret.append("30 Tage bzw. 360 Tage");
                    break;
                }
                case 5: {
                    ret.append("30 Tage bzw. 365 Tage");
                    break;
                }
                case 3: {
                    ret.append("30 Tage bzw. 365/366 Tage");
                    break;
                }
                default: {
                    ret.append("(unknown)");
                }
            }
            ret.append(")");
            return ret.toString().trim();
        }
    }
}

