/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Value;

public class GVRCardList
extends HBCIJobResultImpl {
    private List<CardInfo> entries = new ArrayList<CardInfo>();

    public GVRCardList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(CardInfo info) {
        this.entries.add(info);
    }

    public CardInfo[] getEntries() {
        return this.entries.toArray(new CardInfo[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        int num = 0;
        Iterator<CardInfo> i = this.entries.iterator();
        while (i.hasNext()) {
            ret.append("Karteninfo #").append(++num).append(linesep);
            ret.append(i.next().toString() + linesep);
        }
        return ret.toString().trim();
    }

    public static class CardInfo {
        public int cardtype;
        public String cardnumber;
        public String cardordernumber;
        public String owner;
        public Date validFrom;
        public Date validUntil;
        public Value limit;
        public String comment;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("Karte ").append(this.cardnumber);
            ret.append(" (typ ").append(this.cardtype);
            ret.append(", Folgenummer ").append(this.cardordernumber).append("): ");
            ret.append(this.owner).append(linesep);
            ret.append("G\u00fcltig von ").append(this.validFrom != null ? HBCIUtils.date2StringLocal(this.validFrom) : "unknown");
            ret.append(" bis ").append(this.validUntil != null ? HBCIUtils.date2StringLocal(this.validUntil) : "unknown").append(linesep);
            if (this.limit != null) {
                ret.append("Kartenlimit: ").append(this.limit).append(linesep);
            }
            if (this.comment != null) {
                ret.append("Bemerkungen: ").append(this.comment).append(linesep);
            }
            return ret.toString().trim();
        }
    }
}

