/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVDauerList
extends AbstractHBCIJob {
    public GVDauerList(HBCIPassportInternal passport) {
        super(passport, GVDauerList.getLowlevelName(), new GVRDauerList(passport));
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
        this.addConstraint("orderid", "orderid", "");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "DauerList";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String usage;
        HashMap<String, String> result = msgstatus.getData();
        GVRDauerList.Dauer entry = new GVRDauerList.Dauer();
        entry.my = new Konto();
        entry.my.country = result.get(header + ".My.KIK.country");
        entry.my.blz = result.get(header + ".My.KIK.blz");
        entry.my.number = result.get(header + ".My.number");
        entry.my.subnumber = result.get(header + ".My.subnumber");
        this.passport.fillAccountInfo(entry.my);
        entry.other = new Konto();
        entry.other.country = result.get(header + ".Other.KIK.country");
        entry.other.blz = result.get(header + ".Other.KIK.blz");
        entry.other.number = result.get(header + ".Other.number");
        entry.other.subnumber = result.get(header + ".Other.subnumber");
        entry.other.name = result.get(header + ".name");
        entry.other.name2 = result.get(header + ".name2");
        entry.value = new Value(result.get(header + ".BTG.value"), result.get(header + ".BTG.curr"));
        entry.key = result.get(header + ".key");
        entry.addkey = result.get(header + ".addkey");
        int i = 0;
        while ((usage = result.get(header + ".usage." + HBCIUtils.withCounter("usage", i))) != null) {
            entry.addUsage(usage);
            ++i;
        }
        String st = result.get(header + ".date");
        if (st != null) {
            entry.nextdate = HBCIUtils.string2DateISO(st);
        }
        entry.orderid = result.get(header + ".orderid");
        entry.firstdate = HBCIUtils.string2DateISO(result.get(header + ".DauerDetails.firstdate"));
        entry.timeunit = result.get(header + ".DauerDetails.timeunit");
        entry.turnus = Integer.parseInt(result.get(header + ".DauerDetails.turnus"));
        entry.execday = Integer.parseInt(result.get(header + ".DauerDetails.execday"));
        st = result.get(header + ".DauerDetails.lastdate");
        if (st != null) {
            entry.lastdate = HBCIUtils.string2DateISO(st);
        }
        boolean bl = entry.aus_available = result.get(header + ".Aussetzung.annual") != null;
        if (entry.aus_available) {
            entry.aus_annual = result.get(header + ".Aussetzung.annual").equals("J");
            st = result.get(header + ".Aussetzung.startdate");
            if (st != null) {
                entry.aus_start = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.get(header + ".Aussetzung.enddate")) != null) {
                entry.aus_end = HBCIUtils.string2DateISO(st);
            }
            entry.aus_breakcount = result.get(header + ".Aussetzung.number");
            st = result.get(header + ".Aussetzung.newvalue.value");
            if (st != null) {
                entry.aus_newvalue = new Value(st, result.get(header + ".Aussetzung.newvalue.curr"));
            }
        }
        ((GVRDauerList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            HashMap<String, String> p2 = new HashMap<String, String>();
            for (String key : result.keySet()) {
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".orderid")) continue;
                p2.put(key.substring(header.length() + 1), result.get(key));
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

