/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCIExecStatus {
    private static final Logger log = LoggerFactory.getLogger(HBCIExecStatus.class);
    private HBCIDialogStatus dialogStatus;
    private ArrayList<Exception> exceptions = new ArrayList();

    public void addException(Exception e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
        log.error(e.getMessage(), (Throwable)e);
    }

    public HBCIDialogStatus getDialogStatus() {
        return this.dialogStatus;
    }

    public void setDialogStatus(HBCIDialogStatus status) {
        this.dialogStatus = status;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> ret = new ArrayList<String>();
        List<Exception> exc = this.getExceptions();
        if (exc != null && !exc.isEmpty()) {
            for (Exception e : exc) {
                ret.add(HBCIUtils.exception2StringShort(e));
            }
        }
        if (this.getDialogStatus() != null) {
            ret.addAll(this.getDialogStatus().getErrorMessages());
        }
        return ret;
    }

    public String toString() {
        HBCIDialogStatus status;
        StringBuilder ret = new StringBuilder();
        String linesep = System.getProperty("line.separator");
        List<Exception> exc = this.getExceptions();
        if (exc != null) {
            for (Exception e : exc) {
                ret.append(HBCIUtils.exception2StringShort(e));
                ret.append(linesep);
            }
        }
        if ((status = this.getDialogStatus()) != null) {
            ret.append(status.toString()).append(linesep);
        }
        return ret.toString().trim();
    }

    public boolean isOK() {
        boolean ok = true;
        List<Exception> exc = this.getExceptions();
        HBCIDialogStatus status = this.getDialogStatus();
        ok = exc == null || exc.isEmpty();
        return ok &= status != null && status.isOK();
    }
}

