/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIDialogStatus {
    public List<HBCIMsgStatus> msgStatusList;
    public HBCIMsgStatus initStatus;
    public HBCIMsgStatus endStatus;

    public void setInitStatus(HBCIMsgStatus status) {
        this.initStatus = status;
    }

    public void setMsgStatusList(List<HBCIMsgStatus> status) {
        this.msgStatusList = status;
    }

    public void setEndStatus(HBCIMsgStatus status) {
        this.endStatus = status;
    }

    public boolean isOK() {
        boolean ret = true;
        if (this.initStatus != null) {
            ret = this.initStatus.isOK();
        }
        if (this.msgStatusList != null) {
            for (HBCIMsgStatus hbciMsgStatus : this.msgStatusList) {
                ret &= hbciMsgStatus.isOK();
            }
        }
        if (this.endStatus != null) {
            ret &= this.endStatus.isOK();
        }
        return ret;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.initStatus != null) {
            ret.addAll(this.initStatus.getErrorList());
        }
        if (this.msgStatusList != null) {
            this.msgStatusList.forEach(hbciMsgStatus -> ret.addAll(hbciMsgStatus.getErrorList()));
        }
        if (this.endStatus != null) {
            ret.addAll(this.endStatus.getErrorList());
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(HBCIUtils.getLocMsg("STAT_INIT")).append(":").append(System.getProperty("line.separator"));
        if (this.initStatus != null) {
            ret.append(this.initStatus.toString());
        } else {
            ret.append("(not status information available)");
        }
        ret.append(System.getProperty("line.separator"));
        if (this.msgStatusList != null) {
            for (int i = 0; i < this.msgStatusList.size(); ++i) {
                ret.append(HBCIUtils.getLocMsg("STAT_MSG")).append(" #").append(i + 1).append(":").append(System.getProperty("line.separator"));
                ret.append(this.msgStatusList.get(i).toString());
                ret.append(System.getProperty("line.separator"));
            }
        }
        ret.append(HBCIUtils.getLocMsg("STAT_END")).append(":").append(System.getProperty("line.separator"));
        if (this.endStatus != null) {
            ret.append(this.endStatus.toString());
        } else {
            ret.append("(not status information available)");
        }
        ret.append(System.getProperty("line.separator"));
        return ret.toString().trim();
    }
}

