/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.NoSuchElementException;
import org.kapott.hbci.manager.DocumentFactory;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Limit;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractHBCIPassport
implements HBCIPassportInternal,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractHBCIPassport.class);
    protected HBCICallback callback;
    protected Map<String, String> properties;
    private Map<String, String> bpd;
    private Map<String, String> upd;
    private String hbciversion;
    private String country;
    private String blz;
    private String host;
    private Integer port;
    private String userid;
    private String customerid;
    private String sysid;
    private Long sigid;
    private Document syntaxDocument;
    private HBCIProduct hbciProduct;

    public AbstractHBCIPassport(String hbciversion, Map<String, String> properties, HBCICallback callback, HBCIProduct product) {
        this.hbciversion = hbciversion;
        this.callback = callback;
        this.properties = properties;
        this.hbciProduct = product;
        this.init();
    }

    public static HBCIPassport getInstance(HBCICallback callback, Map<String, String> properties, String name, Object init) {
        if (name == null) {
            throw new NullPointerException("name of passport implementation must not be null");
        }
        String className = "org.kapott.hbci.passport.HBCIPassport" + name;
        try {
            if (init == null) {
                init = name;
            }
            log.debug("creating new instance of a " + name + " passport");
            Class<?> cl = Class.forName(className);
            Constructor<?> con = cl.getConstructor(Properties.class, HBCICallback.class, Object.class);
            return (HBCIPassport)con.newInstance(properties, callback, init);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidUserDataException("*** No passport implementation '" + name + "' found - there must be a class " + className);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof HBCI_Exception) {
                throw (HBCI_Exception)cause;
            }
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_PASSPORT_INST", name), ite);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_PASSPORT_INST", name), e);
        }
    }

    public static HBCIPassport getInstance(HBCICallback callback, Map<String, String> properties, Object init) {
        String passportName = properties.get("client.passport.default");
        if (passportName == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_NODEFPASS"));
        }
        return AbstractHBCIPassport.getInstance(callback, properties, passportName, init);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Map<String, String> properties, String name) {
        return AbstractHBCIPassport.getInstance(callback, properties, name, null);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Map<String, String> properties) {
        return AbstractHBCIPassport.getInstance(callback, properties, null);
    }

    private static String pathWithDot(String path) {
        return path.length() == 0 ? path : path + ".";
    }

    private void init() {
        this.syntaxDocument = DocumentFactory.createDocument(this.hbciversion);
        this.setCountry(this.properties.get("client.passport.country"));
        this.setBLZ(this.properties.get("client.passport.blz"));
        this.setCustomerId(this.properties.get("client.passport.customerId"));
        if (this.properties.get("client.passport.userId") != null) {
            this.setUserId(this.properties.get("client.passport.userId"));
        } else {
            this.setUserId(this.getCustomerId());
        }
    }

    @Override
    public final List<Konto> getAccounts() {
        ArrayList<Konto> ret = new ArrayList<Konto>();
        if (this.upd != null) {
            String header;
            String number;
            int i = 0;
            while ((number = this.upd.get((header = HBCIUtils.withCounter("KInfo", i)) + ".KTV.number")) != null) {
                String gvHeader;
                String code;
                Konto entry = new Konto();
                entry.blz = this.upd.get(header + ".KTV.KIK.blz");
                entry.country = this.upd.get(header + ".KTV.KIK.country");
                entry.number = number;
                entry.subnumber = this.upd.get(header + ".KTV.subnumber");
                entry.curr = this.upd.get(header + ".cur");
                entry.type = this.upd.get(header + ".konto");
                entry.customerid = this.upd.get(header + ".customerid");
                entry.name = this.upd.get(header + ".name1");
                entry.name2 = this.upd.get(header + ".name2");
                entry.bic = this.upd.get(header + ".KTV.bic");
                entry.iban = this.upd.get(header + ".KTV.iban");
                entry.acctype = this.upd.get(header + ".acctype");
                String st = this.upd.get(header + ".KLimit.limittype");
                if (st != null) {
                    Limit limit = new Limit();
                    limit.type = st.charAt(0);
                    limit.value = new Value(this.upd.get(header + ".KLimit.BTG.value"), this.upd.get(header + ".KLimit.BTG.curr"));
                    st = this.upd.get(header + ".KLimit.limitdays");
                    if (st != null) {
                        limit.days = Integer.parseInt(st);
                    }
                }
                ArrayList<String> codes = new ArrayList<String>();
                int j = 0;
                while ((code = this.upd.get((gvHeader = HBCIUtils.withCounter(header + ".AllowedGV", j)) + ".code")) != null) {
                    codes.add(code);
                    ++j;
                }
                if (!codes.isEmpty()) {
                    entry.allowedGVs = codes;
                }
                ret.add(entry);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public final void fillAccountInfo(Konto account) {
        String number = HBCIUtils.stripLeadingZeroes(account.number);
        String iban = HBCIUtils.stripLeadingZeroes(account.iban);
        boolean haveNumber = number != null && number.length() != 0;
        boolean haveIBAN = iban != null && iban.length() != 0;
        for (Konto account1 : this.getAccounts()) {
            String tempNumber = HBCIUtils.stripLeadingZeroes(account1.number);
            String tempIban = HBCIUtils.stripLeadingZeroes(account1.iban);
            if ((!haveNumber || !number.equals(tempNumber)) && (!haveIBAN || !iban.equals(tempIban))) continue;
            account.blz = account1.blz;
            account.country = account1.country;
            account.number = account1.number;
            account.subnumber = account1.subnumber;
            account.type = account1.type;
            account.curr = account1.curr;
            account.customerid = account1.customerid;
            account.name = account1.name;
            account.bic = account1.bic;
            account.iban = account1.iban;
            account.acctype = account1.acctype;
            break;
        }
    }

    public final Konto findAccountByAccountNumber(String number) {
        Konto ret = new Konto();
        ret.number = number;
        this.fillAccountInfo(ret);
        if (ret.blz == null) {
            ret.blz = this.getBLZ();
            ret.country = this.getCountry();
            ret.customerid = this.getCustomerId();
            ret.name = this.getCustomerId();
        }
        return ret;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public final void setHost(String host) {
        this.host = host;
    }

    @Override
    public final Integer getPort() {
        return this.port != null ? this.port : 0;
    }

    @Override
    public final void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public String getUserId() {
        return this.userid;
    }

    @Override
    public final void setUserId(String userid) {
        this.userid = userid;
    }

    @Override
    public String getCustomerId() {
        return this.customerid != null && this.customerid.length() != 0 ? this.customerid : this.getUserId();
    }

    @Override
    public final void setCustomerId(String customerid) {
        this.customerid = customerid;
    }

    @Override
    public String getSysId() {
        return this.sysid != null && this.sysid.length() != 0 ? this.sysid : "0";
    }

    @Override
    public final void setSysId(String sysid) {
        this.sysid = sysid;
    }

    @Override
    public final String getBPDVersion() {
        String version = this.bpd != null ? this.bpd.get("BPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getUPDVersion() {
        String version = this.upd != null ? this.upd.get("UPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getInstName() {
        return this.bpd != null ? this.bpd.get("BPA.kiname") : null;
    }

    @Override
    public int getMaxGVperMsg() {
        return this.bpd != null ? Integer.parseInt(this.bpd.get("BPA.numgva")) : -1;
    }

    @Override
    public final int getMaxMsgSizeKB() {
        if (this.bpd != null && this.bpd.get("BPA.maxmsgsize") != null) {
            return Integer.parseInt(this.bpd.get("BPA.maxmsgsize"));
        }
        return 0;
    }

    @Override
    public final String[] getSuppVersions() {
        String[] ret = new String[]{};
        if (this.bpd != null) {
            String value;
            String header;
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while ((header = HBCIUtils.withCounter("BPA.SuppVersions.version", i)) != null && (value = this.bpd.get(header)) != null) {
                temp.add(value);
                ++i;
            }
            if (!temp.isEmpty()) {
                ret = temp.toArray(ret);
            }
        }
        return ret;
    }

    @Override
    public final String getLang() {
        String value = this.bpd != null ? this.bpd.get("CommListRes.deflang") : null;
        return value != null ? value : "0";
    }

    @Override
    public final Long getSigId() {
        return this.sigid != null ? this.sigid : 1L;
    }

    @Override
    public final void setSigId(Long sigid) {
        this.sigid = sigid;
    }

    @Override
    public void incSigId() {
        this.setSigId(this.getSigId() + 1L);
    }

    @Override
    public Map<String, String> getParamSegmentNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        this.bpd.keySet().forEach(key -> {
            if (key.startsWith("Params") && key.endsWith(".SegHead.code")) {
                String knownVersion;
                String version;
                int dotPos = key.indexOf(46);
                int dotPos2 = key.indexOf(46, dotPos + 1);
                String gvname = key.substring(dotPos + 1, dotPos2);
                int len = gvname.length();
                int versionPos = -1;
                for (int i = len - 1; i >= 0; --i) {
                    char ch = gvname.charAt(i);
                    if (ch >= '0' && ch <= '9') continue;
                    versionPos = i + 1;
                    break;
                }
                if ((version = gvname.substring(versionPos)).length() != 0 && ((knownVersion = (String)ret.get(gvname = gvname.substring(0, versionPos - 3))) == null || Integer.parseInt(version) > Integer.parseInt(knownVersion))) {
                    ret.put(gvname, version);
                }
            }
        });
        return ret;
    }

    @Override
    public Map<String, String> getJobRestrictions(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getJobRestrictions(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    @Override
    public Map<String, String> getJobRestrictions(String gvname, String version) {
        HashMap<String, String> result = new HashMap<String, String>();
        String searchstring = gvname + "Par" + version;
        this.bpd.keySet().forEach(key -> {
            if (key.startsWith("Params") && key.contains("." + searchstring + ".Par")) {
                int searchIdx = key.indexOf(searchstring);
                result.put(key.substring(key.indexOf(46, searchIdx + searchstring.length() + 4) + 1), this.bpd.get(key));
            }
        });
        return result;
    }

    @Override
    public Map<String, String> getSupportedLowlevelJobs() {
        Map<String, String> paramSegments = this.getParamSegmentNames();
        HashMap<String, String> result = new HashMap<String, String>();
        paramSegments.keySet().forEach(segName -> {
            if (this.getLowlevelGVs(this.syntaxDocument).containsKey(segName)) {
                result.put((String)segName, (String)paramSegments.get(segName));
            }
        });
        return result;
    }

    @Override
    public boolean jobSupported(String jobName) {
        return this.getSupportedLowlevelJobs().containsKey(jobName);
    }

    @Override
    public Node getSyntaxDef(String type) {
        Element ret = this.syntaxDocument.getElementById(type);
        if (ret == null) {
            throw new NoSuchElementException("element", type);
        }
        return ret;
    }

    @Override
    public Map<String, String> getLowlevelJobRestrictions(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().get(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.getJobRestrictions(gvname, version);
    }

    private HashMap<String, List<String>> getLowlevelGVs(Document document) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Element gvlist = document.getElementById("GV");
        NodeList gvs = gvlist.getChildNodes();
        int len = gvs.getLength();
        StringBuilder type = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch;
            Node gvref = gvs.item(i);
            if (gvref.getNodeType() != 1) continue;
            type.setLength(0);
            type.append(((Element)gvref).getAttribute("type"));
            int pos = type.length() - 1;
            while ((ch = type.charAt(pos)) >= '0' && ch <= '9') {
                --pos;
            }
            String gvname = type.substring(0, pos + 1);
            List entry = result.computeIfAbsent(gvname, k -> new ArrayList());
            entry.add(type.substring(pos + 1));
        }
        return result;
    }

    @Override
    public String getOrderHashMode(int segVersion) {
        return this.getBPD().keySet().stream().filter(key -> {
            if (key.startsWith("Params")) {
                String subkey = key.substring(key.indexOf(46) + 1);
                return subkey.startsWith("TAN2StepPar" + segVersion) && subkey.endsWith(".orderhashmode");
            }
            return false;
        }).findFirst().map(s -> this.getBPD().get(s)).orElse("");
    }

    @Override
    public HBCIProduct getHbciProduct() {
        return this.hbciProduct;
    }

    @Override
    public Document getSyntaxDocument() {
        return this.syntaxDocument;
    }

    @Override
    public final Map<String, String> getBPD() {
        return this.bpd;
    }

    @Override
    public void setBPD(Map<String, String> bpd) {
        this.bpd = bpd;
    }

    @Override
    public final String getHBCIVersion() {
        return this.hbciversion != null ? this.hbciversion : "";
    }

    @Override
    public final Map<String, String> getUPD() {
        return this.upd;
    }

    @Override
    public final void setUPD(Map<String, String> upd) {
        this.upd = upd;
    }

    @Override
    public final String getBLZ() {
        return this.blz;
    }

    @Override
    public final void setBLZ(String blz) {
        this.blz = blz;
    }

    @Override
    public final String getCountry() {
        return this.country;
    }

    @Override
    public final void setCountry(String country) {
        this.country = country;
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 0;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public HBCICallback getCallback() {
        return this.callback;
    }
}

