/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Optional;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.w3c.dom.Document;

public final class MessageFactory {
    private static final HBCIProduct HBCI_PRODUCT = new HBCIProduct("36792786FA12F235F04647689", "3.2");

    static Message createDialogInit(String msgName, String syncMode, HBCIPassportInternal passport) {
        Message message = MessageFactory.createMessage(msgName, passport.getSyntaxDocument());
        message.rawSet("Idn.KIK.blz", passport.getBLZ());
        message.rawSet("Idn.KIK.country", passport.getCountry());
        message.rawSet("Idn.customerid", passport.getCustomerId());
        message.rawSet("Idn.sysid", passport.getSysId());
        message.rawSet("Idn.sysStatus", passport.getSysStatus());
        message.rawSet("ProcPrep.BPD", passport.getBPDVersion());
        message.rawSet("ProcPrep.UPD", passport.getUPDVersion());
        message.rawSet("ProcPrep.lang", passport.getLang());
        HBCIProduct hbciProduct = Optional.ofNullable(passport.getHbciProduct()).orElse(HBCI_PRODUCT);
        message.rawSet("ProcPrep.prodName", hbciProduct.getProduct());
        message.rawSet("ProcPrep.prodVersion", hbciProduct.getVersion());
        if (syncMode != null) {
            message.rawSet("Sync.mode", syncMode);
        }
        return message;
    }

    static Message createAnonymousDialogInit(HBCIPassportInternal passport) {
        Message message = MessageFactory.createMessage("DialogInitAnon", passport.getSyntaxDocument());
        message.rawSet("Idn.KIK.blz", passport.getBLZ());
        message.rawSet("Idn.KIK.country", passport.getCountry());
        message.rawSet("ProcPrep.BPD", "0");
        message.rawSet("ProcPrep.UPD", passport.getUPDVersion());
        message.rawSet("ProcPrep.lang", "0");
        HBCIProduct hbciProduct = Optional.ofNullable(passport.getHbciProduct()).orElse(HBCI_PRODUCT);
        message.rawSet("ProcPrep.prodName", hbciProduct.getProduct());
        message.rawSet("ProcPrep.prodVersion", hbciProduct.getVersion());
        return message;
    }

    static Message createDialogEnd(HBCIPassportInternal passport, String dialogid, long msgNumber) {
        Message message = MessageFactory.createMessage("DialogEnd", passport.getSyntaxDocument());
        message.rawSet("DialogEndS.dialogid", dialogid);
        message.rawSet("MsgHead.dialogid", dialogid);
        message.rawSet("MsgHead.msgnum", Long.toString(msgNumber));
        message.rawSet("MsgTail.msgnum", Long.toString(msgNumber));
        return message;
    }

    public static Message createMessage(String msgName, Document document) {
        return new Message(msgName, document);
    }
}

