/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.rewrite.Rewrite;
import org.kapott.hbci.security.Crypt;
import org.kapott.hbci.security.Sig;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIKernel {
    private static final Logger log = LoggerFactory.getLogger(HBCIKernel.class);
    public static final boolean SIGNIT = true;
    public static final boolean DONT_SIGNIT = false;
    public static final boolean CRYPTIT = true;
    public static final boolean DONT_CRYPTIT = false;
    private HBCIPassportInternal passport;
    private CommPinTan commPinTan;

    public HBCIKernel(HBCIPassportInternal passport) {
        this.passport = passport;
        this.commPinTan = new CommPinTan(passport.getHost(), passport.getCallback()).withProxy(passport.getProxy(), passport.getProxyUser(), passport.getProxyPass());
    }

    HBCIMsgStatus rawDoIt(Message message, boolean signit, boolean cryptit) {
        HBCIMsgStatus msgStatus = new HBCIMsgStatus();
        try {
            log.debug("generating raw message " + message.getName());
            message.complete();
            this.passport.getCallback().status(21, message.getName());
            ArrayList<Rewrite> rewriters = this.getRewriters(this.passport.getProperties().get("kernel.rewriter"));
            for (Rewrite rewriter1 : rewriters) {
                message = rewriter1.outgoingClearText(message);
            }
            if (signit) {
                message = this.signMessage(message, rewriters);
            }
            this.processMessage(message, msgStatus);
            String messageName = message.getName();
            if (cryptit) {
                message = this.cryptMessage(message, rewriters);
            }
            this.sendMessage(message, messageName, msgStatus, rewriters);
        }
        catch (Exception e) {
            if (message.getName().startsWith("DialogEnd")) {
                log.error(e.getMessage(), (Throwable)e);
                log.warn("error while receiving DialogEnd response - but ignoring it because of special setting");
            }
            msgStatus.addException(e);
        }
        return msgStatus;
    }

    private void processMessage(Message message, HBCIMsgStatus msgStatus) {
        HashMap<String, String> paths = new HashMap<String, String>();
        message.getElementPaths(paths, null, null, null);
        msgStatus.addData(paths);
        HashMap<String, String> current = new HashMap<String, String>();
        message.extractValues(current);
        HashMap<String, String> origs = new HashMap<String, String>();
        current.forEach((key, value) -> origs.put("orig_" + key, (String)value));
        msgStatus.addData(origs);
        String outstring = message.toString(0);
        log.debug("sending message: " + outstring);
        int maxmsgsize = this.passport.getMaxMsgSizeKB();
        if (maxmsgsize != 0 && outstring.length() >> 10 > maxmsgsize) {
            String errmsg = HBCIUtils.getLocMsg("EXCMSG_MSGTOOLARGE", new Object[]{Integer.toString(outstring.length() >> 10), Integer.toString(maxmsgsize)});
            throw new HBCI_Exception(errmsg);
        }
    }

    private ArrayList<Rewrite> getRewriters(String rewritersString) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Rewrite> rewriters = new ArrayList<Rewrite>();
        StringTokenizer tok = new StringTokenizer(rewritersString, ",");
        while (tok.hasMoreTokens()) {
            String rewriterName = tok.nextToken().trim();
            if (rewriterName.length() == 0) continue;
            Class<?> cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
            Constructor<?> con = cl.getConstructor(null);
            rewriters.add((Rewrite)con.newInstance(null));
        }
        return rewriters;
    }

    private Message signMessage(Message message, List<Rewrite> rewriters) {
        log.debug("trying to insert signature");
        this.passport.getCallback().status(22, null);
        Sig sig = new Sig();
        if (!sig.signIt(message, this.passport)) {
            String errmsg = HBCIUtils.getLocMsg("EXCMSG_CANTSIGN");
            throw new HBCI_Exception(errmsg);
        }
        for (Rewrite rewriter : rewriters) {
            message = rewriter.outgoingSigned(message);
        }
        return message;
    }

    private Message cryptMessage(Message message, List<Rewrite> rewriters) {
        log.debug("trying to encrypt message");
        this.passport.getCallback().status(23, null);
        Crypt crypt = new Crypt(this.passport);
        message = crypt.cryptIt(message);
        if (!message.getName().equals("Crypted")) {
            String errmsg = HBCIUtils.getLocMsg("EXCMSG_CANTCRYPT");
            throw new HBCI_Exception(errmsg);
        }
        for (Rewrite rewriter : rewriters) {
            message = rewriter.outgoingCrypted(message);
        }
        log.debug("encrypted message to be sent: " + message.toString(0));
        return message;
    }

    private void sendMessage(Message message, String messageName, HBCIMsgStatus msgStatus, List<Rewrite> rewriters) {
        Message response = this.commPinTan.pingpong(message, messageName, rewriters, msgStatus);
        response = this.decryptMessage(rewriters, response, messageName + "Res");
        for (Rewrite rewriter : rewriters) {
            response = rewriter.incomingData(response);
        }
        log.debug("extracting data from received message");
        msgStatus.addData(response.getData());
        this.checkResponse(response);
        this.checkSig(response);
    }

    private void checkSig(Message message) {
        log.debug("looking for a signature");
        this.passport.getCallback().status(26, null);
        if (!new Sig().verify(message, this.passport)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVSIG"));
        }
    }

    private void checkResponse(Message response) {
        String responsePath = response.getPath();
        String msgnum = response.getValueOfDE(responsePath + ".MsgHead.msgnum");
        String dialogid = response.getValueOfDE(responsePath + ".MsgHead.dialogid");
        String hbciversion = response.getValueOfDE(responsePath + ".MsgHead.hbciversion");
        String hbciversion2 = response.getValueOfDE(responsePath + ".MsgHead.hbciversion");
        if (!hbciversion2.equals(hbciversion)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVVERSION", new Object[]{hbciversion2, hbciversion}));
        }
        String msgnum2 = response.getValueOfDE(responsePath + ".MsgHead.msgnum");
        if (!msgnum2.equals(msgnum)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_HEAD", new Object[]{msgnum2, msgnum}));
        }
        msgnum2 = response.getValueOfDE(responsePath + ".MsgTail.msgnum");
        if (!msgnum2.equals(msgnum)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_TAIL", new Object[]{msgnum2, msgnum}));
        }
        String dialogid2 = response.getValueOfDE(responsePath + ".MsgHead.dialogid");
        if (!dialogid.equals("0") && !dialogid2.equals(dialogid)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVDIALOGID", new Object[]{dialogid2, dialogid}));
        }
        if (!dialogid.equals("0") && !response.getValueOfDE(responsePath + ".MsgHead.MsgRef.dialogid").equals(dialogid)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVDIALOGID_REF"));
        }
        if (!response.getValueOfDE(responsePath + ".MsgHead.MsgRef.msgnum").equals(msgnum)) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_REF"));
        }
    }

    private Message decryptMessage(List<Rewrite> rewriters, Message response, String responseMessageName) {
        if (response.getName().equals("CryptedRes")) {
            this.passport.getCallback().status(25, null);
            log.debug("acquire crypt instance");
            Crypt crypt = new Crypt(this.passport);
            log.debug("decrypting using " + crypt);
            String responseString = crypt.decryptIt(response);
            log.debug("rewriting message");
            for (Rewrite rewriter : rewriters) {
                log.debug("applying rewriter " + rewriter.getClass().getSimpleName());
                responseString = rewriter.incomingClearText(responseString);
            }
            log.debug("rewriting done");
            log.debug("decrypted message after rewriting: " + responseString);
            try {
                this.passport.getCallback().status(28, response.getName() + "Res");
                log.debug("message to pe parsed: " + response.toString(0));
                response = new Message(responseMessageName, responseString, this.passport.getSyntaxDocument(), true, true);
            }
            catch (Exception ex) {
                throw new CanNotParseMessageException(HBCIUtils.getLocMsg("EXCMSG_CANTPARSE"), responseString, ex);
            }
        }
        log.debug("received message after decryption: " + response.toString(0));
        return response;
    }
}

