/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIInstitute
implements IHandlerData {
    private static final Logger log = LoggerFactory.getLogger(HBCIInstitute.class);
    private static final String BPD_KEY_LASTUPDATE = "_lastupdate";
    private static final String BPD_KEY_HBCIVERSION = "_hbciversion";
    private static final String maxAge = "7";
    private HBCIPassportInternal passport;
    private HBCIKernel kernel;

    HBCIInstitute(HBCIKernel kernel, HBCIPassportInternal passport) {
        this.kernel = kernel;
        this.passport = passport;
    }

    void updateBPD(HashMap<String, String> result) {
        log.debug("extracting BPD from results");
        HashMap<String, String> newBPD = new HashMap<String, String>();
        result.keySet().forEach(key -> {
            if (key.startsWith("BPD.")) {
                newBPD.put(key.substring("BPD.".length()), (String)result.get(key));
            }
        });
        if (newBPD.size() != 0) {
            newBPD.put(BPD_KEY_HBCIVERSION, this.passport.getHBCIVersion());
            newBPD.put(BPD_KEY_LASTUPDATE, String.valueOf(System.currentTimeMillis()));
            this.passport.setBPD(newBPD);
            log.info("installed new BPD with version " + this.passport.getBPDVersion());
            this.passport.getCallback().status(4, this.passport.getBPD());
        }
    }

    private boolean isBPDExpired() {
        Map<String, String> bpd = this.passport.getBPD();
        log.info("[BPD] max age: 7 days");
        long maxMillis = -1L;
        try {
            int days = Integer.parseInt(maxAge);
            if (days == 0) {
                log.info("[BPD] auto-expiry disabled");
                return false;
            }
            if (days > 0) {
                maxMillis = (long)(days * 24 * 60 * 60) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        long lastUpdate = 0L;
        if (bpd != null) {
            String lastUpdateProperty = bpd.get(BPD_KEY_LASTUPDATE);
            try {
                lastUpdate = lastUpdateProperty != null ? Long.parseLong(lastUpdateProperty) : lastUpdate;
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
            log.info("[BPD] last update: " + (lastUpdate == 0L ? "never" : new Date(lastUpdate)));
        }
        long now = System.currentTimeMillis();
        if (maxMillis < 0L || now - lastUpdate > maxMillis) {
            log.info("[BPD] expired, will be updated now");
            return true;
        }
        return false;
    }

    void fetchBPDAnonymous() {
        Map<String, String> bpd = this.passport.getBPD();
        String hbciVersionOfBPD = bpd != null ? bpd.get(BPD_KEY_HBCIVERSION) : null;
        String version = this.passport.getBPDVersion();
        if (version.equals("0") || this.isBPDExpired() || hbciVersionOfBPD == null || !hbciVersionOfBPD.equals(this.passport.getHBCIVersion())) {
            try {
                if (!version.equals("0")) {
                    log.info("resetting BPD version from " + version + " to 0");
                    this.passport.getBPD().put("BPA.version", "0");
                }
                this.passport.getCallback().status(3, null);
                log.info("fetching BPD");
                HBCIMsgStatus msgStatus = this.anonymousDialogInit();
                this.updateBPD(msgStatus.getData());
                if (!msgStatus.isDialogClosed()) {
                    this.anonymousDialogEnd(msgStatus.getData());
                }
                if (!msgStatus.isOK()) {
                    log.error("fetching BPD failed");
                    throw new ProcessException(HBCIUtils.getLocMsg("ERR_INST_BPDFAILED"), msgStatus);
                }
            }
            catch (HBCI_Exception e) {
                if (e.isFatal()) {
                    throw e;
                }
            }
            catch (Exception e) {
                log.info("FAILED! - maybe this institute does not support anonymous logins");
                log.info("we will nevertheless go on");
            }
        }
        log.debug("checking if requested hbci parameters are supported");
        if (this.passport.getBPD() != null) {
            if (!Arrays.asList(this.passport.getSuppVersions()).contains(this.passport.getHBCIVersion())) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_VERSIONNOTSUPP");
                throw new InvalidUserDataException(msg);
            }
        } else {
            log.warn("can not check if requested parameters are supported");
        }
    }

    private HBCIMsgStatus anonymousDialogInit() {
        Message dialogInitMessage = MessageFactory.createAnonymousDialogInit(this.passport);
        return this.kernel.rawDoIt(dialogInitMessage, false, false);
    }

    private void anonymousDialogEnd(HashMap<String, String> result) {
        try {
            this.anonymousDialogEnd(result.get("MsgHead.dialogid"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void anonymousDialogEnd(String dialogid) {
        this.passport.getCallback().status(19, null);
        Message message = MessageFactory.createMessage("DialogEndAnon", this.passport.getSyntaxDocument());
        message.rawSet("MsgHead.dialogid", dialogid);
        message.rawSet("MsgHead.msgnum", "2");
        message.rawSet("DialogEndS.dialogid", dialogid);
        message.rawSet("MsgTail.msgnum", "2");
        HBCIMsgStatus status = this.kernel.rawDoIt(message, false, false);
        this.passport.getCallback().status(20, status);
        if (!status.isOK()) {
            log.error("dialog end failed: " + status.getErrorList());
            String msg = HBCIUtils.getLocMsg("ERR_INST_ENDFAILED");
            throw new ProcessException(msg, status);
        }
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.passport;
    }
}

