/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.callback;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.kapott.hbci.callback.HBCICallback;

public abstract class AbstractHBCICallback
implements HBCICallback {
    protected String createDefaultLogLine(String msg, int level, Date date, StackTraceElement trace) {
        String[] levels = new String[]{"NON", "ERR", "WRN", "INF", "DBG", "DB2", "INT"};
        StringBuffer ret = new StringBuffer(128);
        ret.append("<").append(levels[level]).append("> ");
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        ret.append("[").append(df.format(date)).append("] ");
        Thread thread = Thread.currentThread();
        ret.append("[").append(thread.getThreadGroup().getName());
        ret.append("/").append(thread.getName()).append("] ");
        String classname = trace.getClassName();
        String hbciname = "org.kapott.hbci.";
        if (classname != null && classname.startsWith(hbciname)) {
            ret.append(classname.substring(hbciname.length())).append(": ");
        }
        if (msg == null) {
            msg = "";
        }
        StringBuffer escapedString = new StringBuffer();
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char ch = msg.charAt(i);
            char x = ch;
            if (x < '\u001a' && x != '\t' && x != '\n' && x != '\r' || ch == '\\') {
                String temp = Integer.toString(x, 16);
                if (temp.length() != 2) {
                    temp = "0" + temp;
                }
                escapedString.append("\\").append(temp);
                continue;
            }
            escapedString.append(ch);
        }
        ret.append(escapedString);
        return ret.toString();
    }

    @Override
    public final void status(int statusTag, Object o) {
        this.status(statusTag, new Object[]{o});
    }
}

