/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Map;
import org.kapott.hbci.GV.GVUeb;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;

public final class GVUebBZU
extends GVUeb {
    public GVUebBZU(HBCIPassportInternal passport) {
        super(passport, GVUebBZU.getLowlevelName());
        this.addConstraint("src.country", "My.KIK.country", "DE");
        this.addConstraint("src.blz", "My.KIK.blz", null);
        this.addConstraint("src.number", "My.number", null);
        this.addConstraint("src.subnumber", "My.subnumber", "");
        this.addConstraint("dst.country", "Other.KIK.country", "DE");
        this.addConstraint("dst.blz", "Other.KIK.blz", null);
        this.addConstraint("dst.number", "Other.number", null);
        this.addConstraint("dst.subnumber", "Other.subnumber", "");
        this.addConstraint("btg.value", "BTG.value", null);
        this.addConstraint("btg.curr", "BTG.curr", null);
        this.addConstraint("name", "name", null);
        this.addConstraint("bzudata", "usage.usage", null);
        this.addConstraint("name2", "name2", "");
        this.addConstraint("key", "key", "67");
        Map<String, String> parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.get("maxusage"));
        for (int i = 1; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "");
        }
    }

    public static String getLowlevelName() {
        return "Ueb";
    }

    private void checkBZUData(String bzudata) {
        if (bzudata == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_BZUMISSING"));
        }
        int len = bzudata.length();
        if (len != 13) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_INV_BZULEN", Integer.toString(len)));
        }
        byte[] digits = bzudata.getBytes();
        int p = 10;
        int s = 0;
        for (int j = 1; j <= 13; ++j) {
            s = p % 11 + (digits[j - 1] - 48);
            int mod = s % 10;
            if (mod == 0) {
                mod = 10;
            }
            p = mod << 1;
        }
        if (s % 10 != 1) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_BZUERR", bzudata);
            throw new InvalidUserDataException(msg);
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("bzudata")) {
            this.checkBZUData(value);
        }
        super.setParam(paramName, value);
    }
}

