/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRTermUebEdit;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class GVTermUebEdit
extends AbstractHBCIJob {
    public GVTermUebEdit(HBCIPassportInternal passport) {
        super(passport, GVTermUebEdit.getLowlevelName(), new GVRTermUebEdit(passport));
        this.addConstraint("src.country", "My.KIK.country", "DE");
        this.addConstraint("src.blz", "My.KIK.blz", null);
        this.addConstraint("src.number", "My.number", null);
        this.addConstraint("src.subnumber", "My.subnumber", "");
        this.addConstraint("dst.country", "Other.KIK.country", "DE");
        this.addConstraint("dst.blz", "Other.KIK.blz", null);
        this.addConstraint("dst.number", "Other.number", "");
        this.addConstraint("dst.subnumber", "Other.subnumber", "");
        this.addConstraint("btg.value", "BTG.value", null);
        this.addConstraint("btg.curr", "BTG.curr", null);
        this.addConstraint("name", "name", null);
        this.addConstraint("date", "date", null);
        this.addConstraint("orderid", "id", null);
        this.addConstraint("name2", "name2", "");
        this.addConstraint("key", "key", "51");
        Map<String, String> parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.get("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "");
        }
    }

    public static String getLowlevelName() {
        return "TermUebEdit";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRTermUebEdit)this.jobResult).setOrderId(orderid);
        ((GVRTermUebEdit)this.jobResult).setOrderIdOld(result.get(header + ".orderidold"));
        if (orderid != null && orderid.length() != 0) {
            Map<String, String> p = this.getLowlevelParams();
            HashMap<String, String> p2 = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : p.entrySet()) {
                if (entry.getKey().endsWith(".id")) continue;
                p2.put(entry.getKey().substring(entry.getKey().indexOf(".") + 1), entry.getValue());
            }
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        super.setParam(paramName, value);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

