/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIUser
implements IHandlerData {
    private static final Logger log = LoggerFactory.getLogger(HBCIUser.class);
    private HBCIPassportInternal passport;
    private HBCIKernel kernel;

    HBCIUser(HBCIKernel kernel, HBCIPassportInternal passport) {
        this.kernel = kernel;
        this.passport = passport;
    }

    private void fetchSysId() {
        HBCIMsgStatus syncStatus = null;
        try {
            this.passport.getCallback().status(9, null);
            log.info("fetching new sys-id from institute");
            this.passport.setSigId(1L);
            this.passport.setSysId("0");
            syncStatus = this.doDialogInit("Synch", "0");
            if (!syncStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), syncStatus);
            }
            HashMap<String, String> syncResult = syncStatus.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport);
            inst.updateBPD(syncResult);
            this.updateUPD(syncResult);
            this.passport.setSysId(syncResult.get("SyncRes.sysid"));
            this.passport.getCallback().status(10, new Object[]{syncStatus, this.passport.getSysId()});
            log.debug("new sys-id is " + this.passport.getSysId());
            this.doDialogEnd(syncResult.get("MsgHead.dialogid"));
            if (syncStatus != null) {
                this.passport.postInitResponseHook(syncStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (syncStatus != null) {
                    this.passport.postInitResponseHook(syncStatus);
                }
                throw throwable;
            }
        }
    }

    private void fetchSigId() {
        HBCIMsgStatus msgStatus = null;
        try {
            this.passport.getCallback().status(15, null);
            log.info("syncing signature id");
            this.passport.setSigId(new Long("9999999999999999"));
            msgStatus = this.doDialogInit("Synch", "2");
            if (!msgStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), msgStatus);
            }
            HashMap<String, String> syncResult = msgStatus.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport);
            inst.updateBPD(syncResult);
            this.updateUPD(syncResult);
            this.passport.setSigId(new Long(syncResult.get("SyncRes.sigid") != null ? syncResult.get("SyncRes.sigid") : "1"));
            this.passport.incSigId();
            this.passport.getCallback().status(16, new Object[]{msgStatus, this.passport.getSigId()});
            log.debug("signature id set to " + this.passport.getSigId());
            this.doDialogEnd(syncResult.get("MsgHead.dialogid"));
            if (msgStatus != null) {
                this.passport.postInitResponseHook(msgStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (msgStatus != null) {
                    this.passport.postInitResponseHook(msgStatus);
                }
                throw throwable;
            }
        }
    }

    void updateUPD(Map<String, String> result) {
        log.debug("extracting UPD from results");
        HashMap<String, String> newUpd = new HashMap<String, String>();
        result.forEach((key, value) -> {
            if (key.startsWith("UPD.")) {
                newUpd.put(key.substring(4), (String)value);
            }
        });
        if (newUpd.size() != 0) {
            newUpd.put("_hbciversion", this.passport.getHBCIVersion());
            String oldVersion = this.passport.getUPDVersion();
            this.passport.setUPD(newUpd);
            log.info("installed new UPD [old version: " + oldVersion + ", new version: " + this.passport.getUPDVersion() + "]");
            this.passport.getCallback().status(12, this.passport.getUPD());
        }
    }

    private void fetchUPD() {
        try {
            this.passport.getCallback().status(11, null);
            log.info("fetching UPD (BPD-Version: " + this.passport.getBPDVersion() + ")");
            HBCIMsgStatus msgStatus = this.doDialogInit("DialogInit", null);
            if (!msgStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_GETUPDFAIL"), msgStatus);
            }
            HashMap<String, String> result = msgStatus.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport);
            inst.updateBPD(result);
            this.passport.postInitResponseHook(msgStatus);
            this.updateUPD(result);
            this.doDialogEnd(result.get("MsgHead.dialogid"));
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_GETUPDFAIL"), e);
        }
    }

    private HBCIMsgStatus doDialogInit(String messageName, String syncMode) {
        Message message = MessageFactory.createDialogInit(messageName, syncMode, this.passport);
        return this.kernel.rawDoIt(message, true, true);
    }

    private void doDialogEnd(String dialogid) {
        this.passport.getCallback().status(19, null);
        Message message = MessageFactory.createMessage("DialogEnd", this.passport.getSyntaxDocument());
        message.rawSet("MsgHead.dialogid", dialogid);
        message.rawSet("MsgHead.msgnum", "2");
        message.rawSet("DialogEndS.dialogid", dialogid);
        message.rawSet("MsgTail.msgnum", "2");
        HBCIMsgStatus status = this.kernel.rawDoIt(message, true, true);
        this.passport.getCallback().status(20, status);
        if (!status.isOK()) {
            log.error("dialog end failed: " + status.getErrorList());
            String msg = HBCIUtils.getLocMsg("ERR_INST_ENDFAILED");
            throw new ProcessException(msg, status);
        }
    }

    void updateUserData() {
        String hbciVersionOfUPD;
        if (this.passport.getSysStatus().equals("1")) {
            if (this.passport.getSysId().equals("0")) {
                this.fetchSysId();
            }
            if (this.passport.getSigId() == -1L) {
                this.fetchSigId();
            }
        }
        Map<String, String> upd = this.passport.getUPD();
        Map<String, String> bpd = this.passport.getBPD();
        String string = hbciVersionOfUPD = upd != null ? upd.get("_hbciversion") : null;
        if (bpd == null || this.passport.getUPD() == null || hbciVersionOfUPD == null || !hbciVersionOfUPD.equals(this.passport.getHBCIVersion())) {
            this.fetchUPD();
        }
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.passport;
    }
}

