/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKUmsAllCamt
extends AbstractSEPAGV {
    private static final Logger log = LoggerFactory.getLogger(GVKUmsAllCamt.class);

    public GVKUmsAllCamt(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRKUms(passport));
    }

    public GVKUmsAllCamt(HBCIPassportInternal passport) {
        this(passport, GVKUmsAllCamt.getLowlevelName());
        this.addConstraint("my.bic", "KTV.bic", null);
        this.addConstraint("my.iban", "KTV.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("my.country", "KTV.KIK.country", "DE");
            this.addConstraint("my.blz", "KTV.KIK.blz", null);
            this.addConstraint("my.number", "KTV.number", null);
            this.addConstraint("my.subnumber", "KTV.subnumber", "");
        }
        this.addConstraint("suppformat", "formats.suppformat", this.getPainVersion().getURN());
        this.addConstraint("dummy", "allaccounts", "N");
        this.addConstraint("startdate", "startdate", this.getStartdate());
        this.addConstraint("enddate", "enddate", "");
        this.addConstraint("maxentries", "maxentries", "");
        this.addConstraint("offset", "offset", "");
    }

    public static String getLowlevelName() {
        return "KUmsZeitCamt";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return SepaVersion.CAMT_052_001_01;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.CAMT_052;
    }

    private String getStartdate() {
        Map<String, String> bpd = this.getJobRestrictions();
        String days = bpd.get("timerange");
        String date = "";
        if (days != null && days.length() > 0 && days.matches("[0-9]{1,4}")) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -Integer.parseInt(days));
            date = HBCIUtils.date2StringISO(cal.getTime());
        }
        log.info("earliest start date according to BPD: " + (date != null && date.length() > 0 ? date : "<none>"));
        return date;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String booked;
        HashMap<String, String> data = msgstatus.getData();
        GVRKUms result = (GVRKUms)this.jobResult;
        String format = data.get(header + ".format");
        int i = 0;
        while ((booked = data.get(header + ".booked." + HBCIUtils.withCounter("message", i))) != null) {
            try {
                SepaVersion version = SepaVersion.choose(format, booked);
                ISEPAParser parser = SEPAParserFactory.get(version);
                log.debug("  parsing camt data: " + booked);
                result.camtBooked.add(booked);
                parser.parse(new ByteArrayInputStream(booked.getBytes("ISO-8859-1")), result.getDataPerDay());
                log.debug("  parsed camt data, entries: " + result.getFlatData().size());
            }
            catch (Exception e) {
                log.error("  unable to parse camt data: " + e.getMessage());
                throw new HBCI_Exception("Error parsing CAMT document", e);
            }
            ++i;
        }
        String notbooked = data.get(header + ".notbooked");
        if (notbooked != null) {
            try {
                SepaVersion version = SepaVersion.choose(format, notbooked);
                ISEPAParser parser = SEPAParserFactory.get(version);
                log.debug("  parsing unbooked camt data: " + notbooked);
                result.camtNotBooked = notbooked;
                parser.parse(new ByteArrayInputStream(notbooked.getBytes("ISO-8859-1")), result.getDataPerDayUnbooked());
                log.debug("  parsed unbooked camt data, entries: " + result.getFlatDataUnbooked().size());
            }
            catch (Exception e) {
                log.error("  unable to parse unbooked camt data: " + e.getMessage());
                throw new HBCI_Exception("Error parsing CAMT document", e);
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }

    @Override
    public String getPainJobName() {
        return GVKUmsAllCamt.getLowlevelName();
    }
}

