/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.util.HashMap;
import java.util.List;
import org.kapott.hbci.GV.GVKUmsAll;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public final class AnalyzeReportOfTransactions {
    public static void main(String[] args) throws Exception {
        HBCIUtils.refreshBLZList(ClassLoader.getSystemResource("blz.properties").openStream());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("client.passport.default", "PinTanNoFile");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", System.getProperty("blz"));
        properties.put("client.passport.customerId", System.getProperty("login"));
        PinTanPassport passport = (PinTanPassport)PinTanPassport.getInstance(new HBCICallbackConsole(), properties);
        HBCIDialog dialog = new HBCIDialog(passport);
        passport.setPIN(System.getProperty("pin"));
        AnalyzeReportOfTransactions.analyzeReportOfTransactions(passport, dialog);
    }

    private static void analyzeReportOfTransactions(HBCIPassportInternal hbciPassport, HBCIDialog hbciDialog) {
        Konto myaccount = hbciPassport.getAccounts().get(0);
        GVKUmsAll bankAccountStatementJob = new GVKUmsAll(hbciPassport);
        bankAccountStatementJob.setParam("my", myaccount);
        hbciDialog.addTask(bankAccountStatementJob);
        HBCIExecStatus ret = hbciDialog.execute(true);
        GVRKUms result = (GVRKUms)bankAccountStatementJob.getJobResult();
        if (result.isOK()) {
            System.out.println("************************** RESULT of **************************");
            System.out.println("****************  AnalyzeReportOfTransactions  ****************\n");
            System.out.println(result.toString());
            System.out.println("***************************************************************");
            List<GVRKUms.UmsLine> lines = result.getFlatData();
            for (GVRKUms.UmsLine entry : lines) {
                List<String> usages = entry.usage;
                for (String usageline : usages) {
                    System.out.println(usageline);
                }
            }
        } else {
            System.out.println("Job-Error");
            System.out.println(result.getJobStatus().getErrorString());
            System.out.println("Global Error");
            System.out.println(ret.getErrorString());
        }
    }

    @Deprecated
    public final void main_multithreaded(String[] str) {
    }
}

