/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.kapott.hbci.exceptions.NoValueGivenException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.exceptions.PredelimErrorException;
import org.kapott.hbci.exceptions.TooMuchElementsException;
import org.kapott.hbci.protocol.MultipleDEGs;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MultipleSyntaxElements {
    private static final Logger log = LoggerFactory.getLogger(MultipleSyntaxElements.class);
    private List<SyntaxElement> elements;
    private String path;
    private String name;
    private String type;
    private int minnum;
    private int maxnum;
    private int syntaxIdx;
    private Document document;
    private Node ref;
    private SyntaxElement parent;

    protected MultipleSyntaxElements(Node ref, String path, Document document) {
        this.initData(ref, path, document);
    }

    protected MultipleSyntaxElements(Node ref, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        this.initData(ref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
    }

    protected abstract SyntaxElement createAndAppendNewElement(Node var1, String var2, int var3, Document var4);

    protected abstract SyntaxElement parseAndAppendNewElement(Node var1, String var2, char var3, int var4, StringBuilder var5, int var6, Document var7, Map<String, String> var8, Map<String, String> var9);

    private void initData(Node ref, String path, Document document) {
        this.type = ((Element)ref).getAttribute("type");
        this.name = ((Element)ref).getAttribute("name");
        if (this.name.length() == 0) {
            this.name = this.type;
        }
        this.elements = new ArrayList<SyntaxElement>();
        this.parent = null;
        this.syntaxIdx = -1;
        this.ref = ref;
        this.document = document;
        StringBuilder temppath = new StringBuilder(128);
        if (path != null && path.length() != 0) {
            temppath.append(path).append(".");
        }
        temppath.append(this.name);
        this.path = temppath.toString();
        this.minnum = 1;
        String st = ((Element)ref).getAttribute("minnum");
        if (st.length() != 0) {
            this.minnum = Integer.parseInt(st);
        }
        this.maxnum = 1;
        st = ((Element)ref).getAttribute("maxnum");
        if (st.length() != 0) {
            this.maxnum = Integer.parseInt(st);
        }
        SyntaxElement child = this.createAndAppendNewElement(ref, path, 0, document);
        if (child != null) {
            child.setParent(this);
        }
        for (int i = 1; i < this.minnum; ++i) {
            child = this.createAndAppendNewElement(ref, path, i, document);
            if (child == null) continue;
            child.setParent(this);
        }
    }

    protected void init(Node ref, String path, Document document) {
        this.initData(ref, path, document);
    }

    protected boolean propagateValue(String destPath, String value, boolean tryToCreate, boolean allowOverwrite) {
        boolean ret = false;
        if (tryToCreate) {
            int destPathLen = destPath.length();
            int pathLen = this.path.length();
            if (destPath.startsWith(this.path) && destPathLen > pathLen && destPath.charAt(pathLen) == '_') {
                int number;
                int nextDot = destPath.indexOf(".", pathLen);
                if (nextDot == -1) {
                    nextDot = destPathLen;
                }
                if ((number = Integer.parseInt(destPath.substring(pathLen + 1, nextDot))) > this.elements.size()) {
                    String temppath = this.path.substring(0, this.path.lastIndexOf("."));
                    for (int i = this.elements.size(); i < number; ++i) {
                        SyntaxElement child = this.createAndAppendNewElement(this.ref, temppath, i, this.document);
                        if (child == null) continue;
                        child.setParent(this);
                    }
                }
            }
        }
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            String ePath = e.getPath();
            if (!destPath.equals(ePath) && !destPath.startsWith(ePath + ".") || !e.propagateValue(destPath, value, tryToCreate, allowOverwrite)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public SyntaxElement getParent() {
        return this.parent;
    }

    public void setParent(SyntaxElement parent) {
        this.parent = parent;
    }

    public int getSyntaxIdx() {
        return this.syntaxIdx;
    }

    public void setSyntaxIdx(int syntaxIdx) {
        this.syntaxIdx = syntaxIdx;
    }

    protected boolean storeValidValueInDE(String destPath, String value) {
        boolean ret = false;
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            String ePath = e.getPath();
            if (!destPath.equals(ePath) && !destPath.startsWith(ePath + ".")) continue;
            if (!e.storeValidValueInDE(destPath, value)) break;
            ret = true;
            break;
        }
        return ret;
    }

    protected String getValueOfDE(String path) {
        String ret = null;
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            String ePath = e.getPath();
            if (!path.equals(ePath) && !path.startsWith(ePath + ".")) continue;
            ret = e.getValueOfDE(path);
            break;
        }
        return ret;
    }

    protected String getValueOfDE(String path, int zero) {
        String ret = null;
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            String ePath = e.getPath();
            if (!path.equals(ePath) && !path.startsWith(ePath + ".")) continue;
            ret = e.getValueOfDE(path, 0);
            break;
        }
        return ret;
    }

    protected SyntaxElement getElement(String path) {
        SyntaxElement ret = null;
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            String ePath = e.getPath();
            if (!path.equals(ePath) && !path.startsWith(ePath + ".")) continue;
            ret = e.getElement(path);
            break;
        }
        return ret;
    }

    protected void validateOneElement(SyntaxElement elem, int idx) {
        block3: {
            try {
                elem.validate();
            }
            catch (NoValueGivenException e) {
                if (idx >= this.minnum && idx + 1 >= this.elements.size()) break block3;
                throw e;
            }
        }
        if (this.maxnum > 0 && idx >= this.maxnum) {
            throw new TooMuchElementsException(this.getPath(), idx);
        }
    }

    protected void validate() {
        int idx = 0;
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            SyntaxElement e = i.next();
            this.validateOneElement(e, idx++);
        }
    }

    public void addElement(SyntaxElement x) {
        this.elements.add(x);
    }

    public List<SyntaxElement> getElements() {
        return this.elements;
    }

    public String getPath() {
        return this.path;
    }

    protected String getName() {
        return this.name;
    }

    protected String getType() {
        return this.type;
    }

    protected int enumerateSegs(int startValue, boolean allowOverwrite) {
        int idx = startValue;
        for (SyntaxElement s : this.getElements()) {
            if (s == null) continue;
            idx = s.enumerateSegs(idx, allowOverwrite);
        }
        return idx;
    }

    private void initData(Node ref, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        this.ref = null;
        this.document = null;
        this.syntaxIdx = -1;
        this.elements = new ArrayList<SyntaxElement>();
        this.type = ((Element)ref).getAttribute("type");
        this.name = ((Element)ref).getAttribute("name");
        if (this.name.length() == 0) {
            this.name = this.type;
        }
        this.parent = null;
        StringBuilder temppath = new StringBuilder(128);
        if (path != null && path.length() != 0) {
            temppath.append(path).append(".");
        }
        temppath.append(this.name);
        this.path = temppath.toString();
        this.minnum = 1;
        String st = ((Element)ref).getAttribute("minnum");
        if (st.length() != 0) {
            this.minnum = Integer.parseInt(st);
        }
        this.maxnum = 1;
        st = ((Element)ref).getAttribute("maxnum");
        if (st.length() != 0) {
            this.maxnum = Integer.parseInt(st);
        }
        int idx = 0;
        boolean ready = false;
        while (!ready) {
            boolean emptyElementFound;
            StringBuilder save;
            block19: {
                save = new StringBuilder(res.toString());
                emptyElementFound = false;
                try {
                    SyntaxElement child = this.parseAndAppendNewElement(ref, path, idx == 0 ? predelim0 : predelim1, idx, res, fullResLen, document, predefs, valids);
                    if (child != null) {
                        child.setParent(this);
                    }
                }
                catch (ParseErrorException e) {
                    if (e.isFatal()) {
                        throw e;
                    }
                    if (save.length() > 1) {
                        char secondChar;
                        if (this instanceof MultipleDEGs && this.minnum == 0 && this.maxnum > 1 && idx > 1) {
                            String rest;
                            int size = this.maxnum - idx;
                            if (size > save.length()) {
                                size = save.length();
                            }
                            if (this.containsOnly(rest = save.substring(0, size), '+')) {
                                log.debug("applying shortcut for optional MultipleDEGs, have no more content in according range");
                                res.replace(0, res.length(), res.substring(size - 1));
                                ready = true;
                                continue;
                            }
                        }
                        if ((secondChar = save.charAt(1)) == '+' || secondChar == ':' || secondChar == '\'') {
                            if (!(e instanceof PredelimErrorException)) {
                                save.deleteCharAt(0);
                            }
                            emptyElementFound = true;
                        }
                    } else {
                        emptyElementFound = true;
                    }
                    res.replace(0, res.length(), save.toString());
                    if (idx < this.minnum) {
                        throw new ParseErrorException("reststring in " + this.getPath() + ": " + res.toString(), e);
                    }
                    if (emptyElementFound) break block19;
                    ready = true;
                }
            }
            if ((this.maxnum == 0 || ++idx < this.maxnum) && (this.maxnum != 0 || !save.toString().equals(res.toString()) || emptyElementFound)) continue;
            ready = true;
        }
    }

    protected void init(Node ref, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        this.initData(ref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
    }

    protected void extractValues(Map<String, String> values) {
        ListIterator<SyntaxElement> i = this.elements.listIterator();
        while (i.hasNext()) {
            ((SyntaxElement)i.next()).extractValues(values);
        }
    }

    protected int checkSegSeq(int value) {
        Iterator<SyntaxElement> i = this.elements.iterator();
        while (i.hasNext()) {
            value = i.next().checkSegSeq(value);
        }
        return value;
    }

    public String toString(int zero) {
        return this.toString();
    }

    public void getElementPaths(Map<String, String> p, int[] segref, int[] degref, int[] deref) {
    }

    private boolean containsOnly(String s, char c) {
        for (char c2 : s.toCharArray()) {
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    protected void destroy() {
        this.elements.clear();
        this.elements = null;
        this.name = null;
        this.parent = null;
        this.path = null;
        this.ref = null;
        this.document = null;
        this.type = null;
    }
}

