/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CreditTransferTransactionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CurrencyAndAmountSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.Pain00100102;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentInstructionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PurposeSCT;

public class ParsePain00100202
extends AbstractSepaParser<List<HashMap<String, String>>> {
    @Override
    public void parse(InputStream xml, List<HashMap<String, String>> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        Pain00100102 pain = doc.getPain00100102();
        if (pain == null) {
            return;
        }
        List<PaymentInstructionInformationSCT> pmtInfs = pain.getPmtInf();
        for (PaymentInstructionInformationSCT pmtInf : pmtInfs) {
            List<CreditTransferTransactionInformationSCT> txList = pmtInf.getCdtTrfTxInf();
            for (CreditTransferTransactionInformationSCT tx : txList) {
                PaymentIdentification1 pmtId;
                XMLGregorianCalendar date;
                PurposeSCT purp;
                HashMap<String, String> prop = new HashMap<String, String>();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getDbtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getDbtrAgt().getFinInstnId().getBIC());
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getCdtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getCdtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.DST_BIC, tx.getCdtrAgt().getFinInstnId().getBIC());
                CurrencyAndAmountSCT amt = tx.getAmt().getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy().value());
                if (tx.getRmtInf() != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdExctnDt()) != null) {
                    this.put(prop, ISEPAParser.Names.DATE, SepaUtil.format(date, null));
                }
                if ((pmtId = tx.getPmtId()) != null) {
                    this.put(prop, ISEPAParser.Names.ENDTOENDID, pmtId.getEndToEndId());
                }
                sepaResults.add(prop);
            }
        }
    }
}

