/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.AccountIdentificationSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ActiveOrHistoricCurrencyAndAmountSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ActiveOrHistoricCurrencyCodeEUR;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.AmountTypeSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.BranchAndFinancialInstitutionIdentificationSEPA1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.CashAccountSEPA1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.CashAccountSEPA2;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ChargeBearerTypeSEPACode;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.CreditTransferTransactionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.CustomerCreditTransferInitiationV03;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.FinancialInstitutionIdentificationSEPA1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.GroupHeaderSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PartyIdentificationSEPA1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PartyIdentificationSEPA2;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PaymentIdentificationSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PaymentInstructionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PaymentMethodSCTCode;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PaymentTypeInformationSCT1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.PurposeSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.RemittanceInformationSEPA1Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ServiceLevelSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_002_03.ServiceLevelSEPACode;

public class GenUebSEPA00100203
extends AbstractSEPAGenerator<HashMap<String, String>> {
    @Override
    public SepaVersion getSepaVersion() {
        return SepaVersion.PAIN_001_002_03;
    }

    @Override
    public void generate(HashMap<String, String> sepaParams, OutputStream os, boolean validate) throws Exception {
        Integer maxIndex = SepaUtil.maxIndex(sepaParams);
        Document doc = new Document();
        doc.setCstmrCdtTrfInitn(new CustomerCreditTransferInitiationV03());
        doc.getCstmrCdtTrfInitn().setGrpHdr(new GroupHeaderSCT());
        String sepaId = sepaParams.get("sepaid");
        String pmtInfId = sepaParams.get("pmtinfid");
        doc.getCstmrCdtTrfInitn().getGrpHdr().setMsgId(sepaId);
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCreDtTm(SepaUtil.createCalendar(null));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setInitgPty(new PartyIdentificationSEPA1());
        doc.getCstmrCdtTrfInitn().getGrpHdr().getInitgPty().setNm(sepaParams.get("src.name"));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        ArrayList pmtInfs = (ArrayList)doc.getCstmrCdtTrfInitn().getPmtInf();
        PaymentInstructionInformationSCT pmtInf = new PaymentInstructionInformationSCT();
        pmtInfs.add(pmtInf);
        pmtInf.setPmtInfId(pmtInfId != null && pmtInfId.length() > 0 ? pmtInfId : sepaId);
        pmtInf.setPmtMtd(PaymentMethodSCTCode.TRF);
        pmtInf.setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        pmtInf.setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        pmtInf.setPmtTpInf(new PaymentTypeInformationSCT1());
        pmtInf.getPmtTpInf().setSvcLvl(new ServiceLevelSEPA());
        pmtInf.getPmtTpInf().getSvcLvl().setCd(ServiceLevelSEPACode.SEPA);
        String date = sepaParams.get("date");
        if (date == null) {
            date = "1999-01-01";
        }
        pmtInf.setReqdExctnDt(SepaUtil.createCalendar(date));
        pmtInf.setDbtr(new PartyIdentificationSEPA2());
        pmtInf.setDbtrAcct(new CashAccountSEPA1());
        pmtInf.setDbtrAgt(new BranchAndFinancialInstitutionIdentificationSEPA1());
        pmtInf.getDbtr().setNm(sepaParams.get("src.name"));
        pmtInf.getDbtrAcct().setId(new AccountIdentificationSEPA());
        pmtInf.getDbtrAcct().getId().setIBAN(sepaParams.get("src.iban"));
        pmtInf.getDbtrAgt().setFinInstnId(new FinancialInstitutionIdentificationSEPA1());
        pmtInf.getDbtrAgt().getFinInstnId().setBIC(sepaParams.get("src.bic"));
        pmtInf.setChrgBr(ChargeBearerTypeSEPACode.SLEV);
        ArrayList cdtTrxTxInfs = (ArrayList)pmtInf.getCdtTrfTxInf();
        if (maxIndex != null) {
            for (int tnr = 0; tnr <= maxIndex; ++tnr) {
                cdtTrxTxInfs.add(this.createCreditTransferTransactionInformationSCT(sepaParams, tnr));
            }
        } else {
            cdtTrxTxInfs.add(this.createCreditTransferTransactionInformationSCT(sepaParams, null));
        }
        String batch = SepaUtil.getProperty(sepaParams, "batchbook", null);
        if (batch != null) {
            pmtInf.setBtchBookg(batch.equals("1"));
        }
        ObjectFactory of = new ObjectFactory();
        this.marshal(of.createDocument(doc), os, validate);
    }

    private CreditTransferTransactionInformationSCT createCreditTransferTransactionInformationSCT(HashMap<String, String> sepaParams, Integer index) {
        String purposeCode;
        CreditTransferTransactionInformationSCT cdtTrxTxInf = new CreditTransferTransactionInformationSCT();
        cdtTrxTxInf.setPmtId(new PaymentIdentificationSEPA());
        cdtTrxTxInf.getPmtId().setEndToEndId(SepaUtil.getProperty(sepaParams, SepaUtil.insertIndex("endtoendid", index), "NOTPROVIDED"));
        cdtTrxTxInf.setCdtr(new PartyIdentificationSEPA2());
        cdtTrxTxInf.getCdtr().setNm(sepaParams.get(SepaUtil.insertIndex("dst.name", index)));
        cdtTrxTxInf.setCdtrAcct(new CashAccountSEPA2());
        cdtTrxTxInf.getCdtrAcct().setId(new AccountIdentificationSEPA());
        cdtTrxTxInf.getCdtrAcct().getId().setIBAN(sepaParams.get(SepaUtil.insertIndex("dst.iban", index)));
        cdtTrxTxInf.setCdtrAgt(new BranchAndFinancialInstitutionIdentificationSEPA1());
        cdtTrxTxInf.getCdtrAgt().setFinInstnId(new FinancialInstitutionIdentificationSEPA1());
        cdtTrxTxInf.getCdtrAgt().getFinInstnId().setBIC(sepaParams.get(SepaUtil.insertIndex("dst.bic", index)));
        cdtTrxTxInf.setAmt(new AmountTypeSEPA());
        cdtTrxTxInf.getAmt().setInstdAmt(new ActiveOrHistoricCurrencyAndAmountSEPA());
        cdtTrxTxInf.getAmt().getInstdAmt().setValue(new BigDecimal(sepaParams.get(SepaUtil.insertIndex("btg.value", index))));
        cdtTrxTxInf.getAmt().getInstdAmt().setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        String usage = sepaParams.get(SepaUtil.insertIndex("usage", index));
        if (usage != null && usage.length() > 0) {
            cdtTrxTxInf.setRmtInf(new RemittanceInformationSEPA1Choice());
            cdtTrxTxInf.getRmtInf().setUstrd(usage);
        }
        if ((purposeCode = sepaParams.get(SepaUtil.insertIndex("purposecode", index))) != null && purposeCode.length() > 0) {
            PurposeSEPA p = new PurposeSEPA();
            p.setCd(purposeCode);
            cdtTrxTxInf.setPurp(p);
        }
        return cdtTrxTxInf;
    }
}

