/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kapott.hbci.rewrite.Rewrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RWrongStatusSegOrder
extends Rewrite {
    private static final Logger log = LoggerFactory.getLogger(RWrongStatusSegOrder.class);

    private List<HashMap<String, String>> createSegmentListFromMessage(String msg) {
        ArrayList<HashMap<String, String>> segmentList = new ArrayList<HashMap<String, String>>();
        boolean quoteNext = false;
        int startPosi = 0;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (!quoteNext && ch == '@') {
                int idx = msg.indexOf("@", i + 1);
                String len_st = msg.substring(i + 1, idx);
                i += Integer.parseInt(len_st) + 1 + len_st.length();
            } else if (!quoteNext && ch == '\'') {
                HashMap<String, String> segmentInfo = new HashMap<String, String>();
                segmentInfo.put("code", msg.substring(startPosi, msg.indexOf(":", startPosi)));
                segmentInfo.put("start", Integer.toString(startPosi));
                segmentInfo.put("length", Integer.toString(i - startPosi + 1));
                segmentList.add(segmentInfo);
                startPosi = i + 1;
            }
            quoteNext = !quoteNext && ch == '?';
        }
        return segmentList;
    }

    @Override
    public String incomingClearText(String st) {
        List<HashMap<String, String>> segmentList = this.createSegmentListFromMessage(st);
        ArrayList<HashMap<String, String>> headerList = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> HIRMGList = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> HIRMSList = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();
        boolean inHeader = true;
        boolean inGlob = false;
        boolean inSeg = false;
        boolean inData = false;
        boolean errorOccured = false;
        for (HashMap<String, String> segmentInfo : segmentList) {
            String segmentCode = segmentInfo.get("code");
            if (segmentCode.equals("HNHBK") || segmentCode.equals("HNSHK")) {
                headerList.add(segmentInfo);
                if (inHeader) continue;
                log.warn("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position");
                errorOccured = true;
                continue;
            }
            if (segmentCode.equals("HIRMG")) {
                HIRMGList.add(segmentInfo);
                if (inHeader) {
                    inHeader = false;
                    inGlob = true;
                }
                if (inGlob) continue;
                log.warn("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position");
                errorOccured = true;
                continue;
            }
            if (segmentCode.equals("HIRMS")) {
                HIRMSList.add(segmentInfo);
                if (inGlob) {
                    inGlob = false;
                    inSeg = true;
                }
                if (inSeg) continue;
                log.warn("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position");
                errorOccured = true;
                continue;
            }
            dataList.add(segmentInfo);
            if (inGlob || inSeg) {
                inGlob = false;
                inSeg = false;
                inData = true;
            }
            if (inData) continue;
            log.warn("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position");
            errorOccured = true;
        }
        StringBuffer new_msg = new StringBuffer();
        if (errorOccured) {
            int counter = 1;
            new_msg.append(this.getDataForSegmentList(st, headerList, counter));
            new_msg.append(this.getDataForSegmentList(st, HIRMGList, counter += headerList.size()));
            new_msg.append(this.getDataForSegmentList(st, HIRMSList, counter += HIRMGList.size()));
            new_msg.append(this.getDataForSegmentList(st, dataList, counter += HIRMSList.size()));
            log.debug("RWrongStatusSegOrder: new message after reordering: " + new_msg);
        } else {
            new_msg.append(st);
        }
        return new_msg.toString();
    }

    private String getDataForSegmentList(String origMsg, List<HashMap<String, String>> list, int counter) {
        StringBuffer data = new StringBuffer();
        for (HashMap<String, String> segmentInfo : list) {
            int start = Integer.parseInt(segmentInfo.get("start"));
            int len = Integer.parseInt(segmentInfo.get("length"));
            StringBuffer segmentData = new StringBuffer(origMsg.substring(start, start + len));
            data.append(segmentData.toString());
            ++counter;
        }
        return data.toString();
    }
}

