/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIInstMessage;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIDialog {
    private static final Logger log = LoggerFactory.getLogger(HBCIDialog.class);
    private String dialogid;
    private long msgnum;
    private List<List<AbstractHBCIJob>> messages = new ArrayList<List<AbstractHBCIJob>>();
    private HashMap<String, String> listOfGVs = new HashMap();
    private PinTanPassport passport;
    private HBCIKernel kernel;

    public HBCIDialog(PinTanPassport passport) {
        this(passport, null, -1L);
    }

    public HBCIDialog(PinTanPassport passport, String dialogid, long msgnum) {
        this.dialogid = dialogid;
        this.msgnum = msgnum;
        this.passport = passport;
        this.kernel = new HBCIKernel(passport);
        this.messages.add(new ArrayList());
        if (dialogid == null) {
            log.debug("creating new dialog");
            this.fetchBPDAnonymous();
            this.registerUser();
        }
    }

    private HBCIMsgStatus doDialogInit() {
        HBCIMsgStatus msgStatus = new HBCIMsgStatus();
        try {
            log.debug(HBCIUtils.getLocMsg("STATUS_DIALOG_INIT"));
            this.passport.getCallback().status(17, null);
            Message message = MessageFactory.createDialogInit("DialogInit", null, this.passport);
            msgStatus = this.kernel.rawDoIt(message, true, true);
            this.passport.postInitResponseHook(msgStatus);
            HashMap<String, String> result = msgStatus.getData();
            if (msgStatus.isOK()) {
                HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport);
                inst.updateBPD(result);
                inst.extractKeys(result);
                HBCIUser user = new HBCIUser(this.kernel, this.passport);
                user.updateUPD(result);
                this.msgnum = 2L;
                this.dialogid = result.get("MsgHead.dialogid");
                log.debug("dialog-id set to " + this.dialogid);
                int i = 0;
                while (true) {
                    HBCIInstMessage msg;
                    try {
                        String header = HBCIUtils.withCounter("KIMsg", i);
                        msg = new HBCIInstMessage(result, header);
                    }
                    catch (Exception e) {
                        break;
                    }
                    this.passport.getCallback().callback(14, msg.toString(), 0, new StringBuilder());
                    ++i;
                }
            }
            this.passport.getCallback().status(18, new Object[]{msgStatus, this.dialogid});
        }
        catch (Exception e) {
            msgStatus.addException(e);
        }
        return msgStatus;
    }

    private void fetchBPDAnonymous() {
        try {
            log.debug("registering institute");
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport);
            inst.fetchBPDAnonymous();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_INST"), ex);
        }
    }

    private void registerUser() {
        try {
            log.debug("registering user");
            HBCIUser user = new HBCIUser(this.kernel, this.passport);
            user.updateUserData();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
        }
    }

    private List<HBCIMsgStatus> doJobs() {
        log.info(HBCIUtils.getLocMsg("LOG_PROCESSING_JOBS"));
        ArrayList<HBCIMsgStatus> messageStatusList = new ArrayList<HBCIMsgStatus>();
        this.messages.forEach(tasks -> {
            int loop = 0;
            HBCIMsgStatus msgstatus = new HBCIMsgStatus();
            while (true) {
                boolean addMsgStatus = true;
                try {
                    int taskNum = 0;
                    Message message = MessageFactory.createMessage("CustomMsg", this.passport.getSyntaxDocument());
                    for (AbstractHBCIJob task : tasks) {
                        if (!task.needsContinue(loop)) continue;
                        task.setContinueOffset(loop);
                        log.debug("adding task " + task.getName());
                        this.passport.getCallback().status(1, task);
                        task.setIdx(taskNum);
                        String header = HBCIUtils.withCounter("GV", taskNum);
                        task.getLowlevelParams().forEach((key, value) -> message.rawSet(header + "." + key, (String)value));
                        ++taskNum;
                    }
                    if (taskNum == 0) {
                        log.debug("loop " + (loop + 1) + " aborted, because there are no more tasks to be executed");
                        addMsgStatus = false;
                        break;
                    }
                    message.rawSet("MsgHead.dialogid", this.dialogid);
                    message.rawSet("MsgHead.msgnum", Long.toString(this.msgnum));
                    message.rawSet("MsgTail.msgnum", Long.toString(this.msgnum));
                    this.nextMsgNum();
                    msgstatus = this.kernel.rawDoIt(message, true, true);
                    int offset = 1;
                    while (true) {
                        String path;
                        if ((path = msgstatus.getData().get(Integer.toString(offset))) == null || path.startsWith("CustomMsg.GV")) {
                            if (path != null) break;
                            offset = 0;
                            break;
                        }
                        ++offset;
                    }
                    if (offset != 0) {
                        for (AbstractHBCIJob task : tasks) {
                            if (!task.needsContinue(loop)) continue;
                            try {
                                task.fillJobResult(msgstatus, offset);
                                this.passport.getCallback().status(2, task);
                            }
                            catch (Exception e) {
                                msgstatus.addException(e);
                            }
                        }
                    }
                    if (msgstatus.hasExceptions()) {
                        log.error("aborting current loop because of errors");
                        break;
                    }
                    ++loop;
                    continue;
                }
                catch (Exception e) {
                    msgstatus.addException(e);
                    continue;
                }
                finally {
                    if (!addMsgStatus) continue;
                    messageStatusList.add(msgstatus);
                    continue;
                }
                break;
            }
        });
        return messageStatusList;
    }

    private HBCIMsgStatus doDialogEnd() {
        HBCIMsgStatus msgStatus = new HBCIMsgStatus();
        try {
            log.debug(HBCIUtils.getLocMsg("LOG_DIALOG_END"));
            this.passport.getCallback().status(19, null);
            Message message = MessageFactory.createDialogEnd(this.passport, this.dialogid, this.msgnum);
            this.nextMsgNum();
            msgStatus = this.kernel.rawDoIt(message, true, true);
            this.passport.getCallback().status(20, msgStatus);
        }
        catch (Exception e) {
            msgStatus.addException(e);
        }
        return msgStatus;
    }

    public HBCIExecStatus execute(boolean closeDialog) {
        HBCIExecStatus ret = new HBCIExecStatus();
        log.debug("executing dialog");
        try {
            ret.setDialogStatus(this.doIt(closeDialog));
        }
        catch (Exception e) {
            ret.addException(e);
        }
        return ret;
    }

    private HBCIDialogStatus doIt(boolean closeDialog) {
        log.debug("executing dialog");
        HBCIDialogStatus dialogStatus = new HBCIDialogStatus();
        if (this.dialogid == null) {
            dialogStatus.setInitStatus(this.doDialogInit());
        }
        if (this.dialogid != null || dialogStatus.initStatus.isOK()) {
            dialogStatus.setMsgStatusList(this.doJobs());
            if (closeDialog) {
                dialogStatus.setEndStatus(this.doDialogEnd());
            }
        }
        return dialogStatus;
    }

    public String getDialogID() {
        return this.dialogid;
    }

    public long getMsgnum() {
        return this.msgnum;
    }

    private void nextMsgNum() {
        ++this.msgnum;
    }

    public void setDialogid(String dialogid) {
        this.dialogid = dialogid;
    }

    private int getTotalNumberOfGVSegsInCurrentMessage() {
        int total = 0;
        for (String hbciCode : this.listOfGVs.keySet()) {
            total += Integer.parseInt(this.listOfGVs.get(hbciCode));
        }
        log.debug("there are currently " + total + " GV segs in this message");
        return total;
    }

    public List<AbstractHBCIJob> addTask(AbstractHBCIJob job) {
        return this.addTask(job, true);
    }

    public List<AbstractHBCIJob> addTask(AbstractHBCIJob job, boolean verify) {
        try {
            String hbciCode;
            log.info(HBCIUtils.getLocMsg("EXCMSG_ADDJOB", job.getName()));
            if (verify) {
                job.verifyConstraints();
            }
            if ((hbciCode = job.getHBCICode()) == null) {
                throw new HBCI_Exception(job.getName() + " not supported");
            }
            int gva_counter = this.listOfGVs.size();
            String counter_st = this.listOfGVs.get(hbciCode);
            int gv_counter = counter_st != null ? Integer.parseInt(counter_st) : 0;
            int total_counter = this.getTotalNumberOfGVSegsInCurrentMessage();
            ++gv_counter;
            ++total_counter;
            if (counter_st == null) {
                ++gva_counter;
            }
            int maxGVA = this.passport.getMaxGVperMsg();
            int maxGVSegJob = job.getMaxNumberPerMsg();
            int maxGVSegTotal = this.passport.getMaxGVSegsPerMsg();
            if (maxGVA > 0 && gva_counter > maxGVA || maxGVSegJob > 0 && gv_counter > maxGVSegJob || maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                if (maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                    log.debug("have to generate new message because current type of passport only allows " + maxGVSegTotal + " GV segs per message");
                } else {
                    log.debug("have to generate new message because of BPD restrictions for number of tasks per message; adding job to this new message");
                }
                this.newMsg();
                gv_counter = 1;
            }
            this.listOfGVs.put(hbciCode, Integer.toString(gv_counter));
            List<AbstractHBCIJob> messageJobs = this.messages.get(this.messages.size() - 1);
            messageJobs.add(job);
            return messageJobs;
        }
        catch (Exception e) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_CANTADDJOB", job.getName());
            log.error("task " + job.getName() + " will not be executed in current dialog");
            throw new HBCI_Exception(msg, e);
        }
    }

    private void newMsg() {
        log.debug("starting new message");
        this.messages.add(new ArrayList());
        this.listOfGVs.clear();
    }

    public List<List<AbstractHBCIJob>> getMessages() {
        return this.messages;
    }

    public PinTanPassport getPassport() {
        return this.passport;
    }

    public HBCIKernel getKernel() {
        return this.kernel;
    }

    public void setKernel(HBCIKernel kernel) {
        this.kernel = kernel;
    }
}

