/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.datatypes.factory.SyntaxDEFactory;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HHDVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChallengeInfo {
    private static final Logger log = LoggerFactory.getLogger(ChallengeInfo.class);
    private static ChallengeInfo singleton = null;
    private Map<String, Job> data;

    public static synchronized ChallengeInfo getInstance() {
        if (singleton == null) {
            singleton = new ChallengeInfo();
        }
        return singleton;
    }

    private ChallengeInfo() {
        log.debug("initializing challenge info engine");
        InputStream dataStream = null;
        String filename = "challengedata.xml";
        dataStream = ChallengeInfo.class.getClassLoader().getResourceAsStream(filename);
        if (dataStream == null) {
            throw new InvalidUserDataException("*** can not load challenge information from " + filename);
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(dataStream);
            dataStream.close();
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** can not load challengedata from file " + filename, e);
        }
        this.data = new HashMap<String, Job>();
        NodeList jobs = doc.getElementsByTagName("job");
        int size = jobs.getLength();
        for (int i = 0; i < size; ++i) {
            Element job = (Element)jobs.item(i);
            String code = job.getAttribute("code");
            this.data.put(code, new Job(job));
        }
        log.debug("challenge information loaded");
    }

    public Job getData(String code) {
        return this.data.get(code);
    }

    public void applyParams(AbstractHBCIJob task, AbstractHBCIJob hktan, HBCITwoStepMechanism hbciTwoStepMechanism) {
        String code = task.getHBCICode();
        Job job = this.getData(code);
        if (job == null) {
            log.info("have no challenge data for " + code + ", will not apply challenge params");
            return;
        }
        HHDVersion version = HHDVersion.find(hbciTwoStepMechanism);
        log.debug("using hhd version " + (Object)((Object)version));
        HhdVersion hhd = job.getVersion(version.getChallengeVersion());
        if (hhd == null) {
            log.info("have no challenge data for " + code + " in " + (Object)((Object)version) + ", will not apply challenge params");
            return;
        }
        String klass = hhd.getKlass();
        log.debug("using challenge klass " + klass);
        hktan.setParam("challengeklass", klass);
        List<Param> params = hhd.getParams();
        for (int i = 0; i < params.size(); ++i) {
            int num = i + 1;
            Param param = params.get(i);
            if (!param.isComplied(hbciTwoStepMechanism)) {
                log.debug("skipping challenge parameter " + num + " (" + param.path + "), condition " + param.conditionName + "=" + param.conditionValue + " not complied");
                continue;
            }
            String value = param.getValue(task);
            if (value == null || value.length() == 0) {
                log.debug("challenge parameter " + num + " (" + param.path + ") is empty");
                continue;
            }
            log.debug("adding challenge parameter " + num + " " + param.path + "=" + value);
            hktan.setParam("ChallengeKlassParam" + num, value);
        }
    }

    public static class Param {
        private String type = null;
        private String path = null;
        private String conditionName = null;
        private String conditionValue = null;

        private Param(Element param) {
            Node content = param.getFirstChild();
            this.path = content != null ? content.getNodeValue() : null;
            this.type = param.getAttribute("type");
            this.conditionName = param.getAttribute("condition-name");
            this.conditionValue = param.getAttribute("condition-value");
        }

        public boolean isComplied(HBCITwoStepMechanism hbciTwoStepMechanism) {
            if (this.conditionName == null || this.conditionName.length() == 0) {
                return true;
            }
            String value = hbciTwoStepMechanism.getNeedchallengevalue();
            return value != null && value.equals(this.conditionValue);
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        private String getValue(AbstractHBCIJob job) {
            if (this.path == null || this.path.length() == 0) {
                return null;
            }
            String value = job.getChallengeParam(this.path);
            return this.format(value);
        }

        public String format(String value) {
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            if (this.type == null || this.type.trim().length() == 0) {
                return value;
            }
            SyntaxDE syntax = SyntaxDEFactory.createSyntaxDE(this.type, this.path, value, 0, 0);
            return syntax.toString(0);
        }
    }

    public static class HhdVersion {
        private String klass = null;
        private List<Param> params = new ArrayList<Param>();

        private HhdVersion(Element spec) {
            this.klass = ((Element)spec.getElementsByTagName("klass").item(0)).getFirstChild().getNodeValue();
            NodeList list = spec.getElementsByTagName("param");
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Element param = (Element)list.item(i);
                this.params.add(new Param(param));
            }
        }

        public String getKlass() {
            return this.klass;
        }

        public List<Param> getParams() {
            return this.params;
        }
    }

    public static class Job {
        private Map<String, HhdVersion> versions = new HashMap<String, HhdVersion>();

        private Job(Element job) {
            NodeList specs = job.getElementsByTagName("challengeinfo");
            int size = specs.getLength();
            for (int i = 0; i < size; ++i) {
                Element spec = (Element)specs.item(i);
                String version = spec.getAttribute("spec");
                this.versions.put(version, new HhdVersion(spec));
            }
        }

        public HhdVersion getVersion(String version) {
            return this.versions.get(version);
        }
    }
}

