/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.NoSuchConstructorException;
import org.kapott.hbci.exceptions.NoSuchSyntaxException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;

public class SyntaxDEFactory {
    public static SyntaxDE createSyntaxDE(String dataType, String path, Object value, int minsize, int maxsize) {
        try {
            Class<?> c = Class.forName("org.kapott.hbci.datatypes.Syntax" + dataType, false, SyntaxDEFactory.class.getClassLoader());
            Constructor<?> con = c.getConstructor(value.getClass(), Integer.TYPE, Integer.TYPE);
            return (SyntaxDE)con.newInstance(value, new Integer(minsize), new Integer(maxsize));
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchSyntaxException(dataType, path);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchConstructorException(dataType);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParseErrorException(HBCIUtils.getLocMsg("EXCMSG_PROT_ERRSYNDE", path), (Exception)e.getCause());
        }
    }
}

