/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.datatypes.SyntaxAN;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.manager.HBCIUtils;

public class SyntaxJN
extends SyntaxAN {
    public SyntaxJN(String x, int minlen, int maxlen) {
        super(SyntaxJN.check(x.trim()), 1, 1);
    }

    public SyntaxJN(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private static String check(String x) {
        if (!x.equals("J") && !x.equals("N")) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXC_DTJN_ONLY_JN"));
        }
        return x;
    }

    @Override
    public void init(String x, int minlen, int maxlen) {
        super.init(SyntaxJN.check(x.trim()), 1, 1);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxJN.skipPreDelim(res);
        int endidx = SyntaxJN.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        this.setContent(SyntaxJN.check(st), 1, 1);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }
}

