/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.kapott.hbci.comm.HBCI4JavaLogOutputStream;
import org.kapott.hbci.comm.PinTanSSLTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinTanSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(PinTanSSLSocketFactory.class);
    private SSLSocketFactory realSocketFactory;

    public PinTanSSLSocketFactory() {
        try {
            log.warn("creating socket factory with disabled cert checking");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new PinTanSSLTrustManager()}, new SecureRandom());
            this.realSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OutputStream getLogger() {
        return new HBCI4JavaLogOutputStream();
    }

    @Override
    public Socket createSocket() throws IOException {
        log.debug("createSocket()");
        return this.realSocketFactory.createSocket();
    }

    @Override
    public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
        log.debug("createSocket(sock,host,port,autoClose)");
        return this.realSocketFactory.createSocket(sock, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.realSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.realSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        log.debug("createSocket(host,port)");
        return this.realSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        log.debug("createSocket(addr,port)");
        return this.realSocketFactory.createSocket(addr, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        log.debug("createSocket(host,port,localHost,localPort)");
        return this.realSocketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHost, int localPort) throws IOException {
        log.debug("createSocket(addr,port,localHost,localPort)");
        return this.realSocketFactory.createSocket(addr, port, localHost, localPort);
    }
}

