/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LoggingInputStream
extends InputStream {
    private InputStream targetInputStream;
    private OutputStream logger;

    public LoggingInputStream(InputStream target, OutputStream logger) {
        this.targetInputStream = target;
        this.logger = logger;
    }

    @Override
    public int read() throws IOException {
        int c = this.targetInputStream.read();
        this.logger.write(c);
        return c;
    }

    @Override
    public void close() throws IOException {
        this.logger.flush();
        this.targetInputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.targetInputStream.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.targetInputStream.read(b, off, len);
        this.logger.write(b, off, result);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.targetInputStream.read(b);
        this.logger.write(b, 0, result);
        return result;
    }
}

