/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;

public class GVRTANList
extends HBCIJobResultImpl {
    private List<TANList> tanlists = new ArrayList<TANList>();

    public GVRTANList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addTANList(TANList list) {
        this.tanlists.add(list);
    }

    public TANList[] getTANLists() {
        return this.tanlists.toArray(new TANList[this.tanlists.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator<TANList> i = this.tanlists.iterator();
        while (i.hasNext()) {
            ret.append(i.next().toString()).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }

    public static class TANList {
        public char status;
        public String number;
        public Date date;
        public int nofTANsPerList;
        public int nofUsedTANsPerList;
        private List<TANInfo> taninfos = new ArrayList<TANInfo>();

        public TANInfo[] getTANInfos() {
            return this.taninfos.toArray(new TANInfo[this.taninfos.size()]);
        }

        public void addTANInfo(TANInfo info) {
            this.taninfos.add(info);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("TANListe Nummer ").append(this.number).append(" Typ:").append(this.status + linesep);
            ret.append("nofTANsPerList: ").append(this.nofTANsPerList).append("; nofUsedTANsPerList: ").append(this.nofUsedTANsPerList + linesep);
            Iterator<TANInfo> i = this.taninfos.iterator();
            while (i.hasNext()) {
                ret.append("  ").append(i.next().toString()).append(linesep);
            }
            return ret.toString().trim();
        }
    }

    public static class TANInfo {
        public static final String[] usageCodes = new String[]{"TAN ist frei", "(not used)", "PIN-\u00c4nderung", "Kontosperre aufheben", "Aktivieren neuer TAN-Liste", "Entwertete TAN (maschinell)", "Mitteilung mit TAN", "\u00dcberweisung", "Wertpapierorder", "Dauerauftrag", "Entwertet wegen Zeit\u00fcberschreitung im Zweischritt-Verfahren", "Entwertet wegen Zeit\u00fcberschreitung im Zweischritt-Verfahren (Mehrfach-Signaturen)", "Entwertet (falsche Antwort auf Challenge?)", "", "", "", "", "", "", "", "Lastschriften", "Euro-\u00dcberweisung", "Auslands\u00fcberweisung", "Termin\u00fcberweisung", "Umbuchung"};
        public int usagecode;
        public String usagetxt;
        public String tan;
        public Date timestamp;

        public String toString() {
            String usage = this.usagecode < usageCodes.length ? usageCodes[this.usagecode] : "(unknown)";
            return "TAN:" + this.tan + " Verwendung:" + this.usagecode + " (" + usage + ") (" + this.usagetxt + ")" + (this.timestamp != null ? " Zeitpunkt:" + HBCIUtils.datetime2StringLocal(this.timestamp) : "");
        }
    }
}

