/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRCardList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Value;

public class GVCardList
extends AbstractHBCIJob {
    public GVCardList(HBCIPassportInternal passport) {
        super(passport, GVCardList.getLowlevelName(), new GVRCardList(passport));
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
    }

    public static String getLowlevelName() {
        return "CardList";
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRCardList.CardInfo info = new GVRCardList.CardInfo();
        info.cardnumber = result.get(header + ".cardnumber");
        info.cardordernumber = result.get(header + ".nextcardnumber");
        info.cardtype = Integer.parseInt(result.get(header + ".cardtype"));
        info.comment = result.get(header + ".comment");
        String st = result.get(header + ".cardlimit.value");
        if (st != null) {
            info.limit = new Value(st, result.get(header + ".cardlimit.curr"));
        }
        info.owner = result.get(header + ".name");
        st = result.get(header + ".validfrom");
        if (st != null) {
            info.validFrom = HBCIUtils.string2DateISO(st);
        }
        if ((st = result.get(header + ".validuntil")) != null) {
            info.validUntil = HBCIUtils.string2DateISO(st);
        }
        ((GVRCardList)this.getJobResult()).addEntry(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

