/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.cryptalgs;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Logger;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.cryptalgs.SignatureParamSpec;

public class ISO9796p1
extends SignatureSpi {
    private RSAPublicKey pubKey;
    private PrivateKey privKey;
    private MessageDigest dig;
    private SignatureParamSpec param;

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String parameter) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        try {
            this.dig = MessageDigest.getInstance(this.param.getHashAlg(), this.param.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.privKey = privateKey;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        try {
            this.dig = MessageDigest.getInstance(this.param.getHashAlg(), this.param.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.pubKey = (RSAPublicKey)publicKey;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param1, Object value) {
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec param1) throws InvalidAlgorithmParameterException {
        if (!(param1 instanceof SignatureParamSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.param = (SignatureParamSpec)param1;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] is;
        BigInteger bModulus;
        if (this.privKey instanceof RSAPrivateKey) {
            bModulus = ((RSAPrivateKey)this.privKey).getModulus();
        } else {
            RSAPrivateCrtKey2 key2 = (RSAPrivateCrtKey2)this.privKey;
            bModulus = key2.getP().multiply(key2.getQ());
        }
        byte[] modulus = bModulus.toByteArray();
        byte[] buffer = this.dig.digest();
        byte[] rr = ISO9796p1.prepareForSig(buffer, bModulus);
        if (this.privKey instanceof RSAPrivateKey) {
            this.getLogger().fine("signing with (n,d)-algorithm");
            BigInteger bPrivExponent = ((RSAPrivateKey)this.privKey).getPrivateExponent();
            BigInteger bIS = new BigInteger(1, rr).modPow(bPrivExponent, bModulus);
            is = bIS.toByteArray();
        } else {
            this.getLogger().fine("signing with (p,q,dP,dQ,qInv)-algorithm");
            RSAPrivateCrtKey2 key2 = (RSAPrivateCrtKey2)this.privKey;
            BigInteger p = key2.getP();
            BigInteger q = key2.getQ();
            BigInteger dP = key2.getdP();
            BigInteger dQ = key2.getdQ();
            BigInteger qInv = key2.getQInv();
            BigInteger encData = new BigInteger(1, rr);
            BigInteger m1 = encData.modPow(dP, p);
            BigInteger m2 = encData.modPow(dQ, q);
            BigInteger h = m1.subtract(m2).multiply(qInv).mod(p);
            is = m2.add(q.multiply(h)).toByteArray();
        }
        byte[] sig = ISO9796p1.getSigFromIS(is, modulus);
        return sig;
    }

    public static byte[] prepareForSig(byte[] buffer, BigInteger bModulus) throws SignatureException {
        byte[] ir;
        byte[] mp = new byte[buffer.length];
        System.arraycopy(buffer, 0, mp, 0, buffer.length);
        int k = bModulus.bitLength() - 1;
        int z = mp.length;
        int r = 1;
        if (z << 4 > k + 3) {
            throw new SignatureException("16*z is greater than k");
        }
        int t = k - 1 >> 4;
        if ((k - 1 & 0xF) != 0) {
            ++t;
        }
        byte[] me = ISO9796p1.getMEfromMP(mp, t);
        byte[] mr = ISO9796p1.getMRfromME(me, t, z, r);
        byte[] rr = ir = ISO9796p1.getIRfromMR(mr, k);
        return rr;
    }

    @Override
    protected int engineSign(byte[] output, int offset, int len) throws SignatureException {
        byte[] sig = this.engineSign();
        if (offset + len > output.length) {
            throw new SignatureException("output result too large for buffer");
        }
        System.arraycopy(sig, 0, output, offset, sig.length);
        return sig.length;
    }

    @Override
    protected void engineUpdate(byte b) {
        this.dig.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.engineUpdate(b[offset + i]);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sig) throws SignatureException {
        BigInteger bExponent = this.pubKey.getPublicExponent();
        byte[] exponent = bExponent.toByteArray();
        BigInteger bModulus = this.pubKey.getModulus();
        byte[] modulus = bModulus.toByteArray();
        byte[] is = ISO9796p1.getISfromSig(sig, exponent, modulus);
        int[] ks = new int[1];
        byte[] ir = ISO9796p1.getIRfromIS(is, exponent, modulus, ks);
        int k = ks[0];
        int[] ts = new int[1];
        byte[] mr = ISO9796p1.getMRfromIR(ir, k, ts);
        int t = ts[0];
        int[] zs = new int[1];
        int[] rs = new int[1];
        byte[] mp = ISO9796p1.getMPfromMR(mr, t, zs, rs);
        int z = zs[0];
        int r = rs[0];
        int datalen = (z << 3) + 1 - r;
        int databytes = datalen >> 3;
        if ((datalen & 7) != 0) {
            ++databytes;
        }
        byte[] recHash = new byte[databytes];
        System.arraycopy(mp, mp.length - databytes, recHash, 0, databytes);
        if ((datalen & 7) != 0) {
            recHash[0] = (byte)(recHash[0] & (1 << (datalen & 7)) - 1);
        }
        BigInteger hash = new BigInteger(1, recHash);
        BigInteger hash2 = new BigInteger(1, this.dig.digest());
        byte[] me2 = ISO9796p1.getMEfromMP(mp, t);
        byte[] mr2 = ISO9796p1.getMRfromME(me2, t, z, r);
        mr[0] = (byte)(mr[0] & (1 << 7 - ((mr.length << 3) - k)) - 1);
        mr2[0] = (byte)(mr2[0] & (1 << 7 - ((mr2.length << 3) - k)) - 1);
        return hash.equals(hash2) && Arrays.equals(mr, mr2);
    }

    private static byte[] getISfromSig(byte[] sig, byte[] exp, byte[] mod) {
        return new BigInteger(1, sig).modPow(new BigInteger(1, exp), new BigInteger(1, mod)).toByteArray();
    }

    private static byte[] getIRfromIS(byte[] is, byte[] exp, byte[] mod, int[] ks) throws SignatureException {
        BigInteger is_b = new BigInteger(1, is);
        BigInteger mod_b = new BigInteger(1, mod);
        BigInteger exp_b = new BigInteger(1, exp);
        BigInteger ret = null;
        if (is_b.mod(new BigInteger("16")).equals(new BigInteger("6"))) {
            ret = is_b;
        } else if (mod_b.subtract(is_b).mod(new BigInteger("16")).equals(new BigInteger("6"))) {
            ret = mod_b.subtract(is_b);
        }
        if (ret == null && exp_b.mod(new BigInteger("2")).compareTo(new BigInteger("0")) == 0) {
            if (is_b.mod(new BigInteger("8")).equals(new BigInteger("3"))) {
                ret = is_b.multiply(new BigInteger("2"));
            } else if (mod_b.subtract(is_b).mod(new BigInteger("8")).equals(new BigInteger("3"))) {
                ret = mod_b.subtract(is_b).multiply(new BigInteger("2"));
            }
        }
        if (ret == null) {
            throw new SignatureException("can not convert IS to IR");
        }
        byte[] reta = ret.toByteArray();
        int k = reta.length << 3;
        int idx = 0;
        int pos = 0;
        while ((reta[idx] & 1 << 7 - pos) == 0) {
            --k;
            if (++pos != 8) continue;
            pos = 0;
            ++idx;
        }
        ks[0] = k;
        if ((reta[reta.length - 1] & 0xF) != 6) {
            throw new SignatureException("last nibble is not 0x06");
        }
        return reta;
    }

    private static byte Perm(int b) {
        return (new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1})[b];
    }

    private static byte Perm1(int b) {
        return (new byte[]{8, 15, 6, 1, 5, 2, 11, 12, 3, 4, 13, 10, 14, 9, 0, 7})[b];
    }

    private static byte[] getMRfromIR(byte[] ir, int k, int[] ts) {
        int t = k - 1 >> 4;
        if ((k - 1 & 0xF) != 0) {
            // empty if block
        }
        ts[0] = ++t;
        byte[] mr = new byte[2 * t];
        int bitsum = 0;
        for (int i = 0; i < 2 * t; ++i) {
            mr[2 * t - 1 - i] = ir[2 * t - 1 - i];
            if ((bitsum += 8) < k) continue;
            int n = 2 * t - 1 - i;
            mr[n] = (byte)(mr[n] & (1 << 7 - (bitsum - k)) - 1);
        }
        mr[2 * t - 1] = (byte)(ISO9796p1.Perm1(mr[2 * t - 2] >> 4 & 0xF) << 4 | mr[2 * t - 1] >> 4 & 0xF);
        return mr;
    }

    private static byte S(int x) {
        return (byte)(ISO9796p1.Perm(x >> 4 & 0xF) << 4 | ISO9796p1.Perm(x & 0xF));
    }

    private static byte[] getMPfromMR(byte[] mr, int t, int[] zs, int[] rs) throws SignatureException {
        int i;
        for (i = 0; i < t; ++i) {
            byte sum = (byte)(ISO9796p1.S(mr[2 * t - 1 - 2 * i]) ^ mr[2 * t - 1 - (2 * i + 1)]);
            if (sum == 0) continue;
            zs[0] = i + 1;
            rs[0] = sum & 0xF;
            break;
        }
        if (i == t) {
            throw new SignatureException("all sums are 0");
        }
        if (rs[0] < 1 || rs[0] > 8) {
            throw new SignatureException("r is not in range 1..8");
        }
        int z = zs[0];
        byte[] mp = new byte[z];
        for (i = 0; i < z; ++i) {
            mp[z - 1 - i] = mr[2 * t - 1 - 2 * i];
        }
        return mp;
    }

    private static byte[] getMEfromMP(byte[] mp, int t) {
        byte[] ret = new byte[t];
        int sum = 0;
        while (sum < t) {
            if (sum + mp.length <= t) {
                System.arraycopy(mp, 0, ret, ret.length - sum - mp.length, mp.length);
                sum += mp.length;
                continue;
            }
            int diff = t - sum;
            System.arraycopy(mp, mp.length - diff, ret, 0, diff);
            sum += diff;
        }
        return ret;
    }

    private static byte[] getMRfromME(byte[] me, int t, int z, int r) {
        byte[] mr = new byte[2 * t];
        for (int i = 0; i < t; ++i) {
            mr[2 * t - 1 - 2 * i] = me[t - 1 - i];
            mr[2 * t - 1 - (2 * i + 1)] = ISO9796p1.S(me[t - 1 - i]);
        }
        int n = t - z << 1;
        mr[n] = (byte)(mr[n] ^ r);
        return mr;
    }

    private static byte[] getIRfromMR(byte[] mr, int k) {
        int len = mr.length;
        byte[] ir = new byte[len];
        System.arraycopy(mr, 0, ir, 0, len);
        ir[0] = (byte)(ir[0] & (1 << 7 - ((len << 3) - k)) - 1);
        ir[0] = (byte)(ir[0] | 1 << 7 - ((len << 3) - k));
        ir[len - 1] = (byte)((ir[len - 1] & 0xF) << 4 | 6);
        return ir;
    }

    private static byte[] getSigFromIS(byte[] is, byte[] modulus) {
        BigInteger bIS = new BigInteger(1, is);
        BigInteger bModulus = new BigInteger(1, modulus);
        BigInteger bIS2 = bModulus.subtract(bIS);
        BigInteger bSig = null;
        bSig = bIS.compareTo(bIS2) < 0 ? bIS : bIS2;
        return bSig.toByteArray();
    }
}

