/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.HashMap;
import java.util.Hashtable;
import org.kapott.hbci.exceptions.InvalidSegSeqException;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.protocol.MultipleDEGs;
import org.kapott.hbci.protocol.MultipleDEs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SEG
extends SyntaxElement {
    public SEG(String type, String name, String path, int idx, Document document) {
        super(type, name, path, idx, document);
    }

    public SEG(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    @Override
    protected String getElementTypeName() {
        return "SEG";
    }

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node ref, Document document) {
        MultipleSyntaxElements ret = null;
        if (ref.getNodeName().equals("DE")) {
            ret = new MultipleDEs(ref, '+', this.getPath(), document);
        } else if (ref.getNodeName().equals("DEG")) {
            ret = new MultipleDEGs(ref, '+', this.getPath(), document);
        }
        return ret;
    }

    @Override
    public void init(String type, String name, String path, int idx, Document document) {
        super.init(type, name, path, idx, document);
    }

    @Override
    public String toString(int dummy) {
        StringBuilder ret = new StringBuilder(256);
        boolean first = true;
        if (this.isValid()) {
            int tooMuch = 0;
            for (MultipleSyntaxElements multipleSyntaxElements : this.getChildContainers()) {
                if (!first) {
                    ret.append('+');
                }
                int saveLen = ret.length();
                if (multipleSyntaxElements != null) {
                    ret.append(multipleSyntaxElements.toString(0));
                }
                tooMuch = ret.length() == saveLen && !first ? ++tooMuch : 0;
                first = false;
            }
            int retlen = ret.length();
            ret.delete(retlen - tooMuch, retlen);
            ret.append('\'');
        }
        return ret.toString();
    }

    public void setSeq(int idx, boolean allowOverwrite) {
        String segcounterPath = "SegHead.seq";
        String targetPath = this.getPath() + "." + segcounterPath;
        if (!this.propagateValue(targetPath, Integer.toString(idx), false, allowOverwrite)) {
            throw new NoSuchPathException(targetPath);
        }
    }

    @Override
    public int enumerateSegs(int idx, boolean allowOverwrite) {
        if (idx == 0 || this.isValid()) {
            this.setSeq(idx, allowOverwrite);
            if (idx != 0) {
                ++idx;
            }
        }
        return idx;
    }

    public String getCode() {
        String codePath = "SegHead.code";
        SyntaxElement code = this.getElement(this.getPath() + "." + codePath);
        return code.toString();
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node dataref, char predelim0, char predelim1, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (dataref.getNodeName().equals("DEG")) {
            ret = new MultipleDEGs(dataref, '+', this.getPath(), predelim0, predelim1, res, document, predefs, valids);
        } else if (dataref.getNodeName().equals("DE")) {
            ret = new MultipleDEs(dataref, '+', this.getPath(), predelim0, predelim1, res, document, predefs, valids);
        }
        return ret;
    }

    @Override
    protected char getInDelim() {
        return '+';
    }

    @Override
    public void init(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    @Override
    public int checkSegSeq(int value) {
        int num = Integer.parseInt(this.getValueOfDE(this.getPath() + ".SegHead.seq"));
        if (num != value) {
            throw new InvalidSegSeqException(this.getPath(), value, num);
        }
        return value + 1;
    }

    @Override
    public void getElementPaths(HashMap<String, String> p, int[] segref, int[] degref, int[] deref) {
        if (this.isValid()) {
            p.put(Integer.toString(segref[0]), this.getPath());
            degref = new int[]{1};
            for (MultipleSyntaxElements l : this.getChildContainers()) {
                if (l == null) continue;
                l.getElementPaths(p, segref, degref, null);
            }
            segref[0] = segref[0] + 1;
        }
    }
}

