/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import java.text.SimpleDateFormat;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;

public final class SyntaxTime
extends SyntaxDE {
    public SyntaxTime(String x, int minsize, int maxsize) {
        super(SyntaxTime.parseTime(x), 6, 6);
    }

    public SyntaxTime(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private static String parseTime(String x) {
        return new SimpleDateFormat("HHmmss").format(HBCIUtils.string2TimeISO(x));
    }

    @Override
    public void init(String x, int minsize, int maxsize) {
        super.init(SyntaxTime.parseTime(x), 6, 6);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxTime.skipPreDelim(res);
        int endidx = SyntaxTime.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        this.unparseTime(st);
        this.setContent(st, 6, 6);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private String unparseTime(String x) {
        try {
            return HBCIUtils.time2StringISO(new SimpleDateFormat("HHmmss").parse(x));
        }
        catch (Exception e) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_TIMEERR"), e);
        }
    }

    @Override
    public String toString() {
        String c = this.getContent();
        return c == null ? "" : this.unparseTime(c);
    }
}

