/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.AccountIdentification2;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.AmountType3;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.CashAccount8;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.ChargeBearerType2Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.CreditTransferTransactionInformation2;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.EuroMax9Amount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.FinancialInstitution2;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.FinancialInstitutionIdentification4;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.GroupHeader20;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.Grouping2Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.Pain00100102;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PartyIdentification20;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PartyIdentification21;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PartyIdentification23;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentInstructionInformation4;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentMethod5Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentTypeInformation7;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.RemittanceInformation3;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.ServiceLevel3Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.ServiceLevel4;

public class GenUebSEPA00100102
extends AbstractSEPAGenerator<HashMap<String, String>> {
    @Override
    public SepaVersion getSepaVersion() {
        return SepaVersion.PAIN_001_001_02;
    }

    @Override
    public void generate(HashMap<String, String> sepaParams, OutputStream os, boolean validate) throws Exception {
        Integer maxIndex = SepaUtil.maxIndex(sepaParams);
        Document doc = new Document();
        doc.setPain00100102(new Pain00100102());
        doc.getPain00100102().setGrpHdr(new GroupHeader20());
        String sepaId = sepaParams.get("sepaid");
        String pmtInfId = sepaParams.get("pmtinfid");
        doc.getPain00100102().getGrpHdr().setMsgId(sepaId);
        doc.getPain00100102().getGrpHdr().setCreDtTm(SepaUtil.createCalendar(null));
        doc.getPain00100102().getGrpHdr().setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        doc.getPain00100102().getGrpHdr().setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        doc.getPain00100102().getGrpHdr().setGrpg(Grouping2Code.GRPD);
        doc.getPain00100102().getGrpHdr().setInitgPty(new PartyIdentification20());
        doc.getPain00100102().getGrpHdr().getInitgPty().setNm(sepaParams.get("src.name"));
        PaymentInstructionInformation4 pmtInf = new PaymentInstructionInformation4();
        doc.getPain00100102().setPmtInf(pmtInf);
        pmtInf.setPmtInfId(pmtInfId != null && pmtInfId.length() > 0 ? pmtInfId : sepaId);
        pmtInf.setPmtMtd(PaymentMethod5Code.TRF);
        pmtInf.setPmtTpInf(new PaymentTypeInformation7());
        pmtInf.getPmtTpInf().setSvcLvl(new ServiceLevel4());
        pmtInf.getPmtTpInf().getSvcLvl().setCd(ServiceLevel3Code.SEPA);
        String date = sepaParams.get("date");
        if (date == null) {
            date = "1999-01-01";
        }
        pmtInf.setReqdExctnDt(SepaUtil.createCalendar(date));
        pmtInf.setDbtr(new PartyIdentification23());
        pmtInf.setDbtrAcct(new CashAccount8());
        pmtInf.setDbtrAgt(new FinancialInstitution2());
        pmtInf.getDbtr().setNm(sepaParams.get("src.name"));
        pmtInf.getDbtrAcct().setId(new AccountIdentification2());
        pmtInf.getDbtrAcct().getId().setIBAN(sepaParams.get("src.iban"));
        pmtInf.getDbtrAgt().setFinInstnId(new FinancialInstitutionIdentification4());
        pmtInf.getDbtrAgt().getFinInstnId().setBIC(sepaParams.get("src.bic"));
        pmtInf.setChrgBr(ChargeBearerType2Code.SLEV);
        ArrayList cdtTrxTxInfs = (ArrayList)pmtInf.getCdtTrfTxInf();
        if (maxIndex != null) {
            for (int tnr = 0; tnr <= maxIndex; ++tnr) {
                cdtTrxTxInfs.add(this.createCreditTransferTransactionInformation2(sepaParams, tnr));
            }
        } else {
            cdtTrxTxInfs.add(this.createCreditTransferTransactionInformation2(sepaParams, null));
        }
        ObjectFactory of = new ObjectFactory();
        this.marshal(of.createDocument(doc), os, validate);
    }

    private CreditTransferTransactionInformation2 createCreditTransferTransactionInformation2(HashMap<String, String> sepaParams, Integer index) {
        CreditTransferTransactionInformation2 cdtTrxTxInf = new CreditTransferTransactionInformation2();
        cdtTrxTxInf.setPmtId(new PaymentIdentification1());
        cdtTrxTxInf.getPmtId().setEndToEndId(SepaUtil.getProperty(sepaParams, SepaUtil.insertIndex("endtoendid", index), "NOTPROVIDED"));
        cdtTrxTxInf.setCdtr(new PartyIdentification21());
        cdtTrxTxInf.getCdtr().setNm(sepaParams.get(SepaUtil.insertIndex("dst.name", index)));
        cdtTrxTxInf.setCdtrAcct(new CashAccount8());
        cdtTrxTxInf.getCdtrAcct().setId(new AccountIdentification2());
        cdtTrxTxInf.getCdtrAcct().getId().setIBAN(sepaParams.get(SepaUtil.insertIndex("dst.iban", index)));
        cdtTrxTxInf.setCdtrAgt(new FinancialInstitution2());
        cdtTrxTxInf.getCdtrAgt().setFinInstnId(new FinancialInstitutionIdentification4());
        cdtTrxTxInf.getCdtrAgt().getFinInstnId().setBIC(sepaParams.get(SepaUtil.insertIndex("dst.bic", index)));
        cdtTrxTxInf.setAmt(new AmountType3());
        cdtTrxTxInf.getAmt().setInstdAmt(new EuroMax9Amount());
        cdtTrxTxInf.getAmt().getInstdAmt().setValue(new BigDecimal(sepaParams.get(SepaUtil.insertIndex("btg.value", index))));
        cdtTrxTxInf.getAmt().getInstdAmt().setCcy("EUR");
        String usage = sepaParams.get(SepaUtil.insertIndex("usage", index));
        if (usage != null && usage.length() > 0) {
            cdtTrxTxInf.setRmtInf(new RemittanceInformation3());
            cdtTrxTxInf.getRmtInf().setUstrd(usage);
        }
        return cdtTrxTxInf;
    }
}

